/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.adapter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.box.api.marshalling.dao.BoxCollection;
import org.nuxeo.box.api.marshalling.dao.BoxFile;
import org.nuxeo.box.api.marshalling.dao.BoxFolder;
import org.nuxeo.box.api.marshalling.dao.BoxItem;
import org.nuxeo.box.api.marshalling.dao.BoxTypedObject;
import org.nuxeo.box.api.marshalling.dao.BoxUser;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.tag.Tag;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocument;
import org.nuxeo.runtime.api.Framework;

public abstract class BoxAdapter {
    protected final DocumentModel doc;
    protected final Map<String, Object> boxProperties = new HashMap<String, Object>();
    protected BoxItem boxItem;
    protected final BoxService boxService = (BoxService)Framework.getLocalService(BoxService.class);

    public BoxAdapter(DocumentModel doc) throws ClientException {
        this.doc = doc;
        CoreSession session = doc.getCoreSession();
        this.boxProperties.put("id", this.boxService.getBoxId(doc));
        this.boxProperties.put("sequence_id", this.boxService.getBoxSequenceId(doc));
        this.boxProperties.put("etag", this.boxService.getBoxEtag(doc));
        this.boxProperties.put("name", doc.getName());
        this.boxProperties.put("created_at", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)doc.getPropertyValue("dc:created"))));
        this.boxProperties.put("modified_at", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)doc.getPropertyValue("dc:modified"))));
        this.boxProperties.put("description", doc.getPropertyValue("dc:description"));
        QuotaAwareDocument quotaAwareDocument = null;
        if (Framework.getRuntime().getBundle("org.nuxeo.ecm.quota.core") != null) {
            quotaAwareDocument = (QuotaAwareDocument)doc.getAdapter(QuotaAware.class);
        }
        this.boxProperties.put("size", quotaAwareDocument != null ? (double)quotaAwareDocument.getInnerSize() : -1.0);
        DocumentModel parentDoc = session.getParentDocument(doc.getRef());
        HashMap<String, Object> pathCollection = new HashMap<String, Object>();
        List<BoxTypedObject> hierarchy = this.getParentsHierarchy(session, parentDoc);
        pathCollection.put("entries", hierarchy);
        pathCollection.put("total_count", hierarchy.size());
        BoxCollection boxPathCollection = new BoxCollection(Collections.unmodifiableMap(pathCollection));
        this.boxProperties.put("path_collection", boxPathCollection);
        HashMap<String, String> parentProperties = new HashMap<String, String>();
        parentProperties.put("id", this.boxService.getBoxId(parentDoc));
        parentProperties.put("sequence_id", this.boxService.getBoxSequenceId(parentDoc));
        parentProperties.put("name", this.boxService.getBoxName(parentDoc));
        parentProperties.put("etag", this.boxService.getBoxEtag(parentDoc));
        BoxFolder parentFolder = new BoxFolder(Collections.unmodifiableMap(parentProperties));
        this.boxProperties.put("parent", parentFolder);
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        String creator = doc.getPropertyValue("dc:creator") != null ? (String)((Object)doc.getPropertyValue("dc:creator")) : "system";
        NuxeoPrincipal principalCreator = userManager.getPrincipal(creator);
        BoxUser boxCreator = this.boxService.fillUser(principalCreator);
        this.boxProperties.put("created_by", boxCreator);
        String lastContributor = doc.getPropertyValue("dc:lastContributor") != null ? (String)((Object)doc.getPropertyValue("dc:lastContributor")) : "system";
        NuxeoPrincipal principalLastContributor = userManager.getPrincipal(lastContributor);
        BoxUser boxContributor = this.boxService.fillUser(principalLastContributor);
        this.boxProperties.put("modified_by", boxContributor);
        this.boxProperties.put("owned_by", boxCreator);
        this.boxProperties.put("shared_link", null);
        this.boxProperties.put("item_status", doc.getCurrentLifeCycleState());
        this.boxProperties.put("tags", this.getTags(session));
    }

    public BoxItem getBoxItem() {
        return this.boxItem;
    }

    public abstract BoxItem getMiniItem();

    public void setBoxItem(BoxItem boxItem) {
        for (String field : boxItem.getKeySet()) {
            this.boxItem.put(field, boxItem.getValue(field));
        }
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    protected List<BoxTypedObject> getParentsHierarchy(CoreSession session, DocumentModel parentDoc) throws ClientException {
        ArrayList<BoxTypedObject> pathCollection = new ArrayList<BoxTypedObject>();
        while (parentDoc != null) {
            HashMap<String, String> parentCollectionProperties = new HashMap<String, String>();
            parentCollectionProperties.put("id", this.boxService.getBoxId(parentDoc));
            parentCollectionProperties.put("sequence_id", this.boxService.getBoxSequenceId(parentDoc));
            parentCollectionProperties.put("etag", this.boxService.getBoxEtag(parentDoc));
            parentCollectionProperties.put("name", this.boxService.getBoxName(parentDoc));
            BoxItem boxParent = parentDoc.isFolder() ? new BoxFolder(Collections.unmodifiableMap(parentCollectionProperties)) : new BoxFile(Collections.unmodifiableMap(parentCollectionProperties));
            pathCollection.add(boxParent);
            parentDoc = session.getParentDocument(parentDoc.getRef());
        }
        return pathCollection;
    }

    protected String[] getTags(CoreSession session) throws ClientException {
        TagService tagService = (TagService)Framework.getLocalService(TagService.class);
        List tags = tagService.getDocumentTags(session, this.doc.getId(), session.getPrincipal().getName());
        String[] tagNames = new String[tags.size()];
        int index = 0;
        for (Tag tag : tags) {
            tagNames[index] = tag.getLabel();
            ++index;
        }
        return tagNames;
    }

    public void save(CoreSession session) throws ClientException, ParseException, InvocationTargetException, IllegalAccessException, BoxJSONException {
        TagService tagService;
        this.setDescription(this.boxItem.getDescription());
        this.setCreator(this.boxItem.getOwnedBy().getId());
        String id = this.boxItem.getParent().getId();
        String newParentId = "0".equals(id) ? session.getRootDocument().getId() : id;
        IdRef documentIdRef = new IdRef(this.doc.getId());
        String oldParentId = session.getParentDocument((DocumentRef)documentIdRef).getId();
        if (!oldParentId.equals(newParentId) || !this.doc.getName().equals(this.boxItem.getName())) {
            session.move((DocumentRef)documentIdRef, (DocumentRef)new IdRef(newParentId), this.boxItem.getName());
            this.setTitle(this.boxItem.getName());
        }
        if ((tagService = (TagService)Framework.getLocalService(TagService.class)) != null && this.boxItem.getTags().length != 0) {
            tagService.removeTags(session, this.doc.getId());
            for (String tag : this.boxItem.getTags()) {
                tagService.tag(session, this.doc.getId(), tag, session.getPrincipal().getName());
            }
        }
        session.saveDocument(this.doc);
        session.save();
    }

    public void setTitle(String value) throws ClientException {
        this.doc.setPropertyValue("dc:title", (Serializable)((Object)value));
    }

    public void setDescription(String value) throws ClientException {
        this.doc.setPropertyValue("dc:description", (Serializable)((Object)value));
    }

    public void setCreator(String value) throws ClientException {
        this.doc.setPropertyValue("dc:creator", (Serializable)((Object)value));
    }
}

