/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.comment;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Date;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.comment.adapter.BoxCommentAdapter;
import org.nuxeo.box.api.file.adapter.BoxFileAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxComment;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.marshalling.exceptions.BoxRestException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="comment")
@Produces(value={"application/json"})
public class BoxCommentObject
extends AbstractResource<ResourceTypeImpl> {
    BoxService boxService;
    BoxFileAdapter boxFile;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
        if (args != null && args.length == 1) {
            try {
                String fileId = (String)args[0];
                CoreSession session = this.ctx.getCoreSession();
                DocumentModel file = session.getDocument((DocumentRef)new IdRef(fileId));
                this.boxFile = (BoxFileAdapter)file.getAdapter(BoxAdapter.class);
            }
            catch (Exception e) {
                throw WebException.wrap((Throwable)e);
            }
            this.setRoot(true);
        }
    }

    @GET
    @Path(value="{commentId}")
    public String doGetComment(@PathParam(value="commentId") String commentId) throws NoSuchDocumentException, ClientException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel comment = session.getDocument((DocumentRef)new IdRef(commentId));
        BoxCommentAdapter commentAdapter = (BoxCommentAdapter)comment.getAdapter(BoxCommentAdapter.class);
        return this.boxService.toJSONString(commentAdapter.getBoxComment());
    }

    @POST
    public String doPostComment(String jsonBoxComment) throws NoSuchDocumentException, ClientException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        BoxComment boxComment = this.boxService.getBoxComment(jsonBoxComment);
        DocumentModel target = session.getDocument((DocumentRef)new IdRef(boxComment.getItem().getId()));
        DocumentModel comment = session.createDocumentModel("Comment");
        comment.setProperty("comment", "text", (Object)boxComment.getMessage());
        comment.setProperty("comment", "author", (Object)session.getPrincipal().getName());
        comment.setProperty("comment", "creationDate", (Object)new Date());
        CommentableDocument commentableDocument = (CommentableDocument)target.getAdapter(CommentableDocument.class);
        if (commentableDocument == null) {
            throw new BoxRestException("This document cannot be commented", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        DocumentModel newComment = commentableDocument.addComment(comment);
        newComment.attach(session.getSessionId());
        BoxCommentAdapter commentAdapter = (BoxCommentAdapter)newComment.getAdapter(BoxCommentAdapter.class);
        return this.boxService.toJSONString(commentAdapter.getBoxComment());
    }

    @PUT
    @Path(value="{commentId}")
    public String doPutComment(@PathParam(value="commentId") String commentId, String jsonBoxComment) throws ClientException, BoxJSONException, ParseException, IllegalAccessException, InvocationTargetException, NoSuchDocumentException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel nxComment = session.getDocument((DocumentRef)new IdRef(commentId));
        BoxComment boxCommentUpdated = this.boxService.getBoxComment(jsonBoxComment);
        BoxCommentAdapter nxDocumentAdapter = (BoxCommentAdapter)nxComment.getAdapter(BoxCommentAdapter.class);
        nxDocumentAdapter.setBoxComment(boxCommentUpdated);
        nxDocumentAdapter.save(session);
        return this.boxService.toJSONString(nxDocumentAdapter.getBoxComment());
    }

    @DELETE
    @Path(value="{commentId}")
    public void doDeleteComment(@PathParam(value="commentId") String commentId) throws ClientException {
        CoreSession session = this.ctx.getCoreSession();
        session.removeDocument((DocumentRef)new IdRef(commentId));
        session.save();
    }

    @GET
    public String doGetComments() throws NoSuchDocumentException, ClientException, BoxJSONException {
        return this.boxService.toJSONString(this.boxFile.getComments());
    }
}

