/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.box.api.marshalling.exceptions.BoxRestException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/box/2.0{repo : (/repo/[^/]+?)?}")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="box")
public class Box
extends ModuleRoot {
    BoxService boxService;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
    }

    @Path(value="/")
    public Object doGetRepository(@PathParam(value="repo") String repositoryParam) throws DocumentNotFoundException {
        if (StringUtils.isNotBlank((String)repositoryParam)) {
            String repoName = repositoryParam.substring("repo/".length() + 1);
            try {
                this.ctx.setRepositoryName(repoName);
            }
            catch (IllegalArgumentException e) {
                throw new WebResourceNotFoundException(e.getMessage());
            }
        }
        return this.newObject("repo", new Object[0]);
    }

    @Path(value="/folders")
    public Object doGetFolder() {
        return this.newObject("folder", new Object[0]);
    }

    @Path(value="/files")
    public Object doGetFile() {
        return this.newObject("file", new Object[0]);
    }

    @Path(value="/search")
    public Object doGetSearch() {
        return this.newObject("search", new Object[0]);
    }

    @Path(value="/comments")
    public Object doGetComment() {
        return this.newObject("comment", new Object[0]);
    }

    @Path(value="/collaborations")
    public Object doGetCollaborations() {
        return this.newObject("collaborations", new Object[0]);
    }

    public Object handleError(WebApplicationException e) {
        if (e instanceof WebSecurityException) {
            return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.boxService.getJSONBoxException((Exception)e, Response.Status.UNAUTHORIZED.getStatusCode())).type("json/application").build();
        }
        if (e instanceof WebResourceNotFoundException) {
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode()).entity((Object)this.boxService.getJSONBoxException((Exception)e, Response.Status.NOT_FOUND.getStatusCode())).type("json/application").build();
        }
        if (e instanceof BoxRestException) {
            return Response.status((int)((BoxRestException)e).getErrorCode()).entity((Object)this.boxService.getJSONBoxException((Exception)e, ((BoxRestException)e).getErrorCode())).type("json/application").build();
        }
        return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).entity((Object)this.boxService.getJSONBoxException((Exception)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())).type("json/application").build();
    }
}

