/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.file;

import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.file.adapter.BoxFileAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxFile;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="file")
@Produces(value={"application/json"})
public class BoxFileObject
extends AbstractResource<ResourceTypeImpl> {
    BoxService boxService;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @GET
    @Path(value="{fileId}")
    public String doGetFile(@PathParam(value="fileId") String fileId) throws DocumentNotFoundException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel file = session.getDocument((DocumentRef)new IdRef(fileId));
        BoxFileAdapter fileAdapter = (BoxFileAdapter)file.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(fileAdapter.getBoxItem());
    }

    @DELETE
    @Path(value="{fileId}")
    public void doDeleteFile(@PathParam(value="fileId") String fileId) {
        CoreSession session = this.ctx.getCoreSession();
        session.removeDocument((DocumentRef)new IdRef(fileId));
        session.save();
    }

    @PUT
    @Path(value="{fileId}")
    public String doUpdateFile(@PathParam(value="fileId") String fileId, String jsonBoxFile) throws BoxJSONException, ParseException, IllegalAccessException, InvocationTargetException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel nxDocument = session.getDocument((DocumentRef)new IdRef(fileId));
        BoxFile boxFileUpdated = this.boxService.getBoxFile(jsonBoxFile);
        BoxFileAdapter nxDocumentAdapter = (BoxFileAdapter)nxDocument.getAdapter(BoxAdapter.class);
        nxDocumentAdapter.setBoxItem(boxFileUpdated);
        nxDocumentAdapter.save(session);
        return this.boxService.toJSONString(nxDocumentAdapter.getBoxItem());
    }

    @POST
    @Path(value="content")
    @Consumes(value={"multipart/form-data"})
    public String doPostFile(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="filename") String fileName, @FormDataParam(value="parent_id") String parentId) throws BoxJSONException, IOException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel documentParent = "0".equals(parentId) ? session.getRootDocument() : session.getDocument((DocumentRef)new IdRef(parentId));
        DocumentModel newFile = session.createDocumentModel(documentParent.getPathAsString(), fileName, "File");
        newFile.setPropertyValue("file:content", (Serializable)Blobs.createBlob((InputStream)uploadedInputStream));
        newFile = session.createDocument(newFile);
        BoxFileAdapter fileAdapter = (BoxFileAdapter)newFile.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(fileAdapter.getBoxItem());
    }

    @Path(value="{fileId}/comments")
    public Object doGetComments(@PathParam(value="fileId") String fileId) {
        return this.newObject("comment", new Object[]{fileId});
    }
}

