/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.folder;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.folder.adapter.BoxFolderAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxFolder;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.marshalling.jsonparsing.BoxJSONParser;
import org.nuxeo.box.api.marshalling.jsonparsing.BoxResourceHub;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="folder")
@Produces(value={"application/json"})
public class BoxFolderObject
extends AbstractResource<ResourceTypeImpl> {
    BoxService boxService;

    public void initialize(Object ... args) {
        this.boxService = (BoxService)Framework.getLocalService(BoxService.class);
    }

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @GET
    @Path(value="{folderId}")
    public String doGetFolder(@PathParam(value="folderId") String folderId) throws DocumentNotFoundException, BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel folder = "0".equals(folderId) ? session.getRootDocument() : session.getDocument((DocumentRef)new IdRef(folderId));
        BoxFolderAdapter folderAdapter = (BoxFolderAdapter)folder.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(folderAdapter.getBoxItem());
    }

    @POST
    public String doPostFolder(String jsonBoxFolder) throws BoxJSONException {
        CoreSession session = this.ctx.getCoreSession();
        BoxFolder boxFolder = this.boxService.getBoxFolder(jsonBoxFolder);
        String parentId = boxFolder.getParent().getId();
        DocumentModel documentParent = "0".equals(parentId) ? session.getRootDocument() : session.getDocument((DocumentRef)new IdRef(boxFolder.getParent().getId()));
        DocumentModel newFolder = session.createDocumentModel(documentParent.getPathAsString(), boxFolder.getName(), "Folder");
        newFolder.setPropertyValue("dc:title", (Serializable)((Object)boxFolder.getName()));
        newFolder = session.createDocument(newFolder);
        BoxFolderAdapter folderAdapter = (BoxFolderAdapter)newFolder.getAdapter(BoxAdapter.class);
        return this.boxService.toJSONString(folderAdapter.getBoxItem());
    }

    @PUT
    @Path(value="{folderId}")
    public String doPutFolder(@PathParam(value="folderId") String folderId, String jsonBoxFolder) throws BoxJSONException, ParseException, IllegalAccessException, InvocationTargetException {
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel nxDocument = session.getDocument((DocumentRef)new IdRef(folderId));
        BoxFolder boxFolderUpdated = new BoxJSONParser(new BoxResourceHub()).parseIntoBoxObject(jsonBoxFolder, BoxFolder.class);
        BoxFolderAdapter nxDocumentAdapter = (BoxFolderAdapter)nxDocument.getAdapter(BoxAdapter.class);
        nxDocumentAdapter.setBoxItem(boxFolderUpdated);
        nxDocumentAdapter.save(session);
        return this.boxService.toJSONString(nxDocumentAdapter.getBoxItem());
    }

    @DELETE
    @Path(value="{folderId}")
    public void doDeleteFolder(@PathParam(value="folderId") String folderId) {
        CoreSession session = this.ctx.getCoreSession();
        session.removeDocument((DocumentRef)new IdRef(folderId));
        session.save();
    }

    @Path(value="{folderId}/items")
    public Object doGetItems(@PathParam(value="folderId") String folderId) {
        return this.newObject("item", new Object[]{folderId});
    }

    @Path(value="{folderId}/collaborations")
    public Object doGetCollaboration(@PathParam(value="folderId") String folderId) {
        return this.newObject("collaborations", new Object[]{folderId});
    }
}

