/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.marshalling.dao;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.box.api.marshalling.jsonentities.DefaultJSONStringEntity;

public class BoxObject
extends DefaultJSONStringEntity {
    private static final Log log = LogFactory.getLog(BoxObject.class);
    private final Map<String, Object> extraMap = new HashMap<String, Object>();
    private final Map<String, Object> map = new HashMap<String, Object>();

    public BoxObject() {
    }

    public BoxObject(Map<String, Object> map) {
        BoxObject.cloneMap(this.map, map);
    }

    public BoxObject(BoxObject obj) {
        BoxObject.cloneMap(this.map, obj.map);
        BoxObject.cloneMap(this.extraMap, obj.extraMap);
    }

    private static void cloneMap(Map<String, Object> destination, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BoxObject) {
                try {
                    destination.put(entry.getKey(), value.getClass().getConstructor(value.getClass()).newInstance(value));
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList<Object> list = new ArrayList<Object>();
                BoxObject.cloneArrayList(list, (ArrayList)value);
                destination.put(entry.getKey(), list);
                continue;
            }
            destination.put(entry.getKey(), value);
        }
    }

    private static void cloneArrayList(ArrayList<Object> destination, ArrayList<Object> source) {
        for (Object obj : source) {
            if (obj instanceof BoxObject) {
                try {
                    destination.add(obj.getClass().getConstructor(obj.getClass()).newInstance(obj));
                }
                catch (ReflectiveOperationException e) {
                    log.error((Object)e, (Throwable)e);
                }
                continue;
            }
            destination.add(obj);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BoxObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BoxObject bObj = (BoxObject)obj;
        return this.map.equals(bObj.map) && this.extraMap.equals(bObj.extraMap);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.map).append(this.extraMap).toHashCode();
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public void putAll(Map<String, Object> newMap) {
        this.map.putAll(newMap);
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public Object getExtraData(String key) {
        return this.extraMap.get(key);
    }

    @JsonAnyGetter
    public Map<String, Object> properties() {
        return this.extraMap;
    }

    public boolean contains(String key) {
        return this.map.containsKey(key) || this.extraMap.containsKey(key);
    }

    @JsonAnySetter
    public void handleUnknown(String key, Object value) {
        if (value instanceof String) {
            this.extraMap.put(key, value);
        }
    }

    @JsonIgnore
    public Set<String> getKeySet() {
        return this.map.keySet();
    }
}

