/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Exit;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class ExitTask
extends Exit {
    private False falseCondition = new False();

    public void execute() throws BuildException {
        String exitMsg = null;
        try {
            super.execute();
            return;
        }
        catch (ExitStatusException e) {
            if (e.getStatus() > 0) {
                throw e;
            }
            exitMsg = e.getMessage();
        }
        catch (BuildException e) {
            exitMsg = e.getMessage();
        }
        this.exit(exitMsg);
    }

    protected void exit(String message) {
        Task doNothing = new Task(){};
        this.getProject().log(message, 2);
        Target owningTarget = this.getOwningTarget();
        Hashtable targets = this.getProject().getTargets();
        for (Target eachTarget : targets.values()) {
            eachTarget.setIf((Condition)this.falseCondition);
            if (eachTarget != owningTarget) continue;
            for (Task task : eachTarget.getTasks()) {
                this.getProject().log("Invalidating tasks from " + eachTarget, 4);
                try {
                    if (task instanceof UnknownElement) {
                        UnknownElement currentTask = (UnknownElement)task;
                        if (currentTask.getRealThing() == this) continue;
                        this.getProject().log("Invalidated " + currentTask.getTaskName(), 4);
                        currentTask.setRealThing((Object)doNothing);
                        continue;
                    }
                    this.getProject().log("Not an UnknownElement: " + task.getTaskName(), 4);
                }
                catch (IllegalArgumentException | SecurityException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    private final class False
    implements Condition {
        private False() {
        }

        public boolean eval() throws BuildException {
            return false;
        }
    }
}

