/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class OldVersion
implements Comparable<OldVersion> {
    protected static final Pattern PATTERN = Pattern.compile("([0-9]+[0-9\\.]*)");
    public static final OldVersion ZERO = new OldVersion(0);
    protected int major;
    protected int minor;
    protected int patch;
    protected String classifier;

    public OldVersion(String version) {
        Matcher m = PATTERN.matcher(version);
        if (m.find()) {
            if (!m.hitEnd()) {
                this.classifier = version.substring(m.end());
                if (this.classifier.startsWith("-")) {
                    this.classifier = this.classifier.substring(1);
                }
            }
            if ((version = m.group(1)).endsWith(".")) {
                version = version.substring(0, version.length() - 1);
            }
        } else {
            throw new IllegalArgumentException("Not a version: " + version);
        }
        int p = version.lastIndexOf(45);
        if (p > 0) {
            this.classifier = version.substring(p + 1) + this.classifier;
            version = version.substring(0, p);
        } else {
            p = version.lastIndexOf(95);
            if (p > 0) {
                this.classifier = version.substring(p + 1) + this.classifier;
                version = version.substring(0, p);
            }
        }
        p = version.indexOf(46, 0);
        if (p > -1) {
            this.major = Integer.parseInt(version.substring(0, p));
            int q = version.indexOf(46, p + 1);
            if (q > -1) {
                this.minor = Integer.parseInt(version.substring(p + 1, q));
                int r = version.indexOf(46, q + 1);
                if (r > 0) {
                    this.patch = Integer.parseInt(version.substring(q + 1, r));
                } else {
                    try {
                        this.patch = Integer.parseInt(version.substring(q + 1));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.minor = Integer.parseInt(version.substring(p + 1));
            }
        } else {
            this.major = Integer.parseInt(version);
        }
    }

    public OldVersion(int major) {
        this(major, 0, 0);
    }

    public OldVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public OldVersion(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public OldVersion(int major, int minor, int patch, String classifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String classifier() {
        return this.classifier;
    }

    public boolean lessThan(OldVersion v) {
        return this.compareTo(v) < 0;
    }

    public boolean lessOrEqualsThan(OldVersion v) {
        return this.compareTo(v) <= 0;
    }

    public boolean equalsTo(OldVersion v) {
        return this.compareTo(v) == 0;
    }

    public boolean greaterThan(OldVersion v) {
        return this.compareTo(v) > 0;
    }

    public boolean greaterOrEqualThan(OldVersion v) {
        return this.compareTo(v) >= 0;
    }

    @Override
    public int compareTo(OldVersion o) {
        int d = this.major - o.major;
        if (d != 0) {
            return d;
        }
        d = this.minor - o.minor;
        if (d != 0) {
            return d;
        }
        d = this.patch - o.patch;
        if (d != 0) {
            return d;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OldVersion) {
            OldVersion v = (OldVersion)obj;
            return v.major == this.major && v.minor == this.minor && v.patch == this.patch;
        }
        return false;
    }

    public int hashCode() {
        return this.major << 16 | this.minor << 8 | this.patch;
    }

    public String toString() {
        if (this.classifier == null) {
            return this.major + "." + this.minor + "." + this.patch;
        }
        return this.major + "." + this.minor + "." + this.patch + "-" + this.classifier;
    }
}

