/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Sequential;
import org.eclipse.aether.artifact.Artifact;
import org.nuxeo.build.ant.artifact.ArtifactSet;

public class ArtifactForeach
extends Sequential {
    public String property;
    public ArtifactSet artifactSet;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public ArtifactSet getArtifactSet() {
        return this.artifactSet;
    }

    public void setSetref(String setref) {
        this.artifactSet = (ArtifactSet)((Object)this.getProject().getReference(setref));
    }

    public void execute() throws BuildException {
        for (Artifact artifact : this.artifactSet.getArtifacts()) {
            String canonicalPath = null;
            try {
                canonicalPath = artifact.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                throw new BuildException("Failed to artifact file canonical path for " + artifact, (Throwable)e);
            }
            this.getProject().setProperty(this.property + ".file.path", canonicalPath);
            this.getProject().setProperty(this.property + ".archetypeId", artifact.getArtifactId());
            this.getProject().setProperty(this.property + ".groupId", artifact.getGroupId());
            this.getProject().setProperty(this.property + ".version", artifact.getBaseVersion());
            try {
                super.execute();
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't execute the task for artifact " + artifact, (Throwable)e);
            }
        }
    }
}

