/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.profile;

import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.ant.profile.Profile;

public class ProfileGroup {
    protected Profile defaultProfile;
    protected Profile[] profiles;

    public ProfileGroup(AntProfileManager mgr, String[] profiles, String defaultProfile) {
        if (defaultProfile != null) {
            this.defaultProfile = mgr.getOrCreateProfile(defaultProfile);
        }
        this.profiles = new Profile[profiles.length];
        Profile activeProfile = null;
        for (int i = 0; i < profiles.length; ++i) {
            String profileName = profiles[i];
            Profile profile = mgr.getOrCreateProfile(profileName);
            if (profile.group != null) {
                throw new BuildException("A profile is part of 2 distinct groups: " + profileName);
            }
            profile.group = this;
            if (profile.isActive()) {
                if (activeProfile != null) {
                    throw new BuildException("Profile Group has 2 active profiles: " + activeProfile.getName() + ", " + profileName);
                }
                activeProfile = profile;
            }
            this.profiles[i] = profile;
        }
        if (activeProfile == null && this.defaultProfile != null) {
            this.defaultProfile._setActive(true);
        }
    }

    void activateProfile(Profile profile, boolean isActive) {
        profile._setActive(isActive);
        for (Profile p : this.profiles) {
            if (p == profile) continue;
            p._setActive(false);
        }
        if (!isActive) {
            this.defaultProfile._setActive(true);
        }
    }

    public Profile getActiveProfile() {
        for (Profile p : this.profiles) {
            if (!p.isActive()) continue;
            return p;
        }
        return null;
    }
}

