/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.filter.Filter;

public abstract class AbstractFilter
implements Filter {
    protected boolean result(boolean condition, String id) {
        if (AntBuildMojo.getInstance().getLog().isDebugEnabled()) {
            AntClient.getInstance().log(String.format("Filtering - %s => %s %s", this.toString(), condition ? "accepted" : "refused", id), 4);
        }
        return condition;
    }

    protected void beforeAccept(Object candidate, Object ... args) {
        String msg = String.format("Filtering - %s on %s", this, candidate);
        if (args != null && args.length > 0) {
            msg = msg + String.format(args[0].toString(), Arrays.copyOfRange(args, 1, args.length));
        }
        AntClient.getInstance().log(msg, 4);
    }

    public abstract boolean accept(DependencyNode var1, List<DependencyNode> var2);

    @Override
    public abstract boolean accept(Artifact var1);
}

