/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.nuxeo.build.maven.filter.AbstractFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Node;

public class DependencyNodeFilter
extends AbstractFilter
implements Filter {
    private Collection<Node> excludedNodes;

    public DependencyNodeFilter(Collection<Node> excludedNodes) {
        this.excludedNodes = excludedNodes;
    }

    @Override
    public boolean accept(Artifact artifact) {
        this.beforeAccept(artifact, " against %s", this.excludedNodes);
        for (Node node : this.excludedNodes) {
            if (!artifact.equals(node.getMavenArtifact())) continue;
            return this.result(false, artifact.toString());
        }
        return this.result(true, artifact.toString());
    }

    @Override
    public boolean accept(DependencyNode dependencyNode, List<DependencyNode> parents) {
        this.beforeAccept(dependencyNode, " against %s", this.excludedNodes);
        for (Node node : this.excludedNodes) {
            if (!node.equals(dependencyNode)) continue;
            return this.result(false, dependencyNode.toString());
        }
        return this.result(true, dependencyNode.toString());
    }
}

