/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.DependencyUtils;
import org.nuxeo.build.maven.graph.Node;

public class Graph {
    public final TreeMap<String, Node> nodes = new TreeMap();
    public final List<Node> roots = new LinkedList<Node>();
    private AntBuildMojo mojo = AntBuildMojo.getInstance();

    public List<Node> getRoots() {
        return this.roots;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    @Deprecated
    public Node findFirst(String pattern) {
        return this.findFirst(pattern, false);
    }

    public Node findFirst(String pattern, boolean stopIfNotUnique) {
        if (pattern.contains("::")) {
            return null;
        }
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        int size = map.size();
        if (size == 0) {
            return null;
        }
        if (stopIfNotUnique && size > 1) {
            AntClient.getInstance().log(String.format("Pattern '%s' cannot be resolved to a unique node. Matching nodes are: %s", pattern, map.values()), 4);
            return null;
        }
        return (Node)map.get(map.firstKey());
    }

    public Collection<Node> find(String pattern) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        return map.values();
    }

    public Node addRootNode(MavenProject pom) {
        Node node = this.nodes.get(Node.genNodeId(pom.getArtifact()));
        if (node == null) {
            node = this.collectRootNode(pom);
        }
        return this.addRootNode(node);
    }

    public Node addRootNode(String key) {
        ArtifactDescriptor ad = new ArtifactDescriptor(key);
        return this.addRootNode(ad.getDependency());
    }

    public Node addRootNode(Dependency dependency) {
        Node node = this.nodes.get(Node.genNodeId(dependency));
        if (node == null) {
            node = this.collectRootNode(dependency);
        } else {
            this.roots.add(node);
            AntClient.getInstance().log("Added root node: " + node, 4);
        }
        return node;
    }

    public Node addRootNode(Node node) {
        if (!this.nodes.containsKey(node.id)) {
            node = this.collectRootNode(node.getDependency());
        } else if (!this.roots.contains(node)) {
            this.roots.add(node);
            AntClient.getInstance().log("Added root node: " + node, 4);
        }
        return this.nodes.get(node.id);
    }

    public Node collectRootNode(Dependency dependency) {
        DependencyNode root = this.collectDependencies(dependency);
        return this.addRootNode(root);
    }

    public Node addRootNode(DependencyNode root) {
        Node node = new Node(this, root);
        this.roots.add(node);
        AntClient.getInstance().log("Added root node: " + node, 4);
        this.addNode(node);
        return node;
    }

    public Node collectRootNode(MavenProject pom) {
        DependencyNode root = this.collectDependencies(pom);
        return this.addRootNode(root);
    }

    private Node resolveRootNode(Node root, Filter filter, int depth) {
        if (!filter.accept(root, null)) {
            return null;
        }
        DependencyResult result = DependencyUtils.resolveDependencies(root, filter, depth);
        Node node = new Node(this, result.getRoot());
        this.roots.add(node);
        AntClient.getInstance().log("Added resolved root node: " + node, 4);
        this.addNode(node);
        return node;
    }

    public void addNode(Node node) {
        if (this.nodes.containsKey(node.getId())) {
            return;
        }
        this.nodes.put(node.getId(), node);
        AntClient.getInstance().log("Added node: " + node, 4);
        if (!this.roots.contains(node)) {
            ArrayList<DependencyNode> removes = new ArrayList<DependencyNode>();
            for (DependencyNode child : node.getChildren()) {
                String childScope = child.getDependency().getScope();
                if (!"provided".equals(childScope) && !"test".equals(childScope)) continue;
                AntClient.getInstance().log("Unexpected child node: " + child + " for " + node, 4);
                removes.add(child);
            }
            node.getChildren().removeAll(removes);
        }
        for (DependencyNode child : node.getChildren()) {
            Node childNode = this.nodes.get(Node.genNodeId(child));
            if (childNode == null) {
                childNode = new Node(this, child);
                this.addNode(childNode);
            }
            childNode.addParent(node);
        }
    }

    public Node findNode(ArtifactDescriptor ad) {
        if (ad.isEmpty()) {
            return null;
        }
        String key = ad.getNodeKeyPattern();
        Collection<Node> nodesToParse = null;
        nodesToParse = key == null ? this.getNodes() : this.find(key);
        Node returnNode = null;
        for (Node node : nodesToParse) {
            org.apache.maven.artifact.Artifact artifact = node.getMavenArtifact();
            if (ad.getArtifactId() != null && !ad.getArtifactId().equals(artifact.getArtifactId()) || ad.getGroupId() != null && !ad.getGroupId().equals(artifact.getGroupId()) || ad.getVersion() != null && !ad.getVersion().equals(artifact.getVersion()) || ad.getType() != null && !ad.getType().equals(artifact.getType()) || ad.getClassifier() != null && !ad.getClassifier().equals(artifact.getClassifier()) || ad.getClassifier() == null && artifact.hasClassifier()) continue;
            try {
                if (returnNode != null && artifact.getSelectedVersion().compareTo((Object)returnNode.getMavenArtifact().getSelectedVersion()) < 0) {
                    continue;
                }
            }
            catch (OverConstrainedVersionException e) {
                this.mojo.getLog().error((CharSequence)("Versions comparison failed on " + artifact), (Throwable)e);
            }
            returnNode = node;
        }
        return returnNode;
    }

    public DependencyNode collectDependencies(Dependency dependency) {
        AntClient.getInstance().log(String.format("Collecting " + dependency, new Object[0]), 4);
        CollectRequest collectRequest = new CollectRequest(dependency, this.mojo.getRemoteRepositories());
        collectRequest.setRequestContext("AAMP graph");
        return this.collect(collectRequest);
    }

    protected DependencyNode collect(CollectRequest collectRequest) {
        try {
            CollectResult result = this.mojo.getSystem().collectDependencies((RepositorySystemSession)this.mojo.getSession(), collectRequest);
            DependencyNode node = result.getRoot();
            AntClient.getInstance().log("Collect result: " + result, 4);
            AntClient.getInstance().log("Collect exceptions: " + result.getExceptions(), 4);
            AntClient.getInstance().log("Direct dependencies: " + String.valueOf(node.getChildren()), 4);
            return node;
        }
        catch (DependencyCollectionException e) {
            throw new BuildException("Cannot collect dependency tree for " + collectRequest, (Throwable)e);
        }
    }

    public DependencyNode collectDependencies(MavenProject project) {
        DependencyManagement depMngt;
        AntClient.getInstance().log(String.format("Collecting " + project, new Object[0]), 4);
        CollectRequest collectRequest = new CollectRequest();
        org.apache.maven.artifact.Artifact rootArtifact = project.getArtifact();
        rootArtifact.setFile(project.getFile());
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)rootArtifact));
        collectRequest.setRoot(RepositoryUtils.toDependency((org.apache.maven.artifact.Artifact)rootArtifact, null));
        collectRequest.setRequestContext("AAMP graph");
        collectRequest.setRepositories(project.getRemoteProjectRepositories());
        ArtifactTypeRegistry stereotypes = this.mojo.getSession().getArtifactTypeRegistry();
        if (project.getDependencyArtifacts() == null) {
            for (org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                if (StringUtils.isEmpty((String)dependency.getGroupId()) || StringUtils.isEmpty((String)dependency.getArtifactId()) || StringUtils.isEmpty((String)dependency.getVersion())) continue;
                collectRequest.addDependency(RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
        } else {
            HashMap<String, org.apache.maven.model.Dependency> dependencies = new HashMap<String, org.apache.maven.model.Dependency>();
            for (org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                ArtifactType type;
                String classifier = dependency.getClassifier();
                if (classifier == null && (type = stereotypes.get(dependency.getType())) != null) {
                    classifier = type.getClassifier();
                }
                String key = ArtifactIdUtils.toVersionlessId((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getType(), (String)classifier);
                dependencies.put(key, dependency);
            }
            Iterator iterator = project.getDependencyArtifacts().iterator();
            while (iterator.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                String key = (artifact = (org.apache.maven.artifact.Artifact)iterator.next()).getDependencyConflictId();
                org.apache.maven.model.Dependency dependency = (org.apache.maven.model.Dependency)dependencies.get(key);
                List exclusions = dependency != null ? dependency.getExclusions() : null;
                Dependency dep = RepositoryUtils.toDependency((org.apache.maven.artifact.Artifact)artifact, (Collection)exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collectRequest.addDependency(dep);
            }
        }
        if ((depMngt = project.getDependencyManagement()) != null) {
            for (org.apache.maven.model.Dependency dependency : depMngt.getDependencies()) {
                collectRequest.addManagedDependency(RepositoryUtils.toDependency((org.apache.maven.model.Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
        }
        return this.collect(collectRequest);
    }

    public void resolveDependencies(Filter filter, int depth) {
        LinkedList<Node> oldRoots = new LinkedList<Node>(this.roots);
        this.roots.clear();
        this.nodes.clear();
        for (Node root : oldRoots) {
            this.resolveRootNode(root, filter, depth);
        }
    }

    protected void tryResolutionOnLocalBaseVersion(org.apache.maven.artifact.Artifact artifact, ArtifactNotFoundException e) throws ArtifactNotFoundException {
        String resolvedVersion = artifact.getVersion();
        artifact.updateVersion(artifact.getBaseVersion(), this.mojo.getLocalRepository());
        File localFile = new File(this.mojo.getLocalRepository().getBasedir(), this.mojo.getLocalRepository().pathOf(artifact));
        if (!localFile.exists()) {
            artifact.updateVersion(resolvedVersion, this.mojo.getLocalRepository());
            this.mojo.getLog().warn((CharSequence)("Cannot resolve " + artifact), (Throwable)e);
            throw e;
        }
        this.mojo.getLog().warn((CharSequence)String.format("Couldn't resolve %s, fallback on local install of unique version %s.", resolvedVersion, artifact.getBaseVersion()));
        artifact.setResolved(true);
    }

    public Node getNode(Dependency dependency) {
        return this.nodes.get(Node.genNodeId(dependency));
    }

    public Node findNode(String key) throws BuildException {
        return this.findNode(key, ArtifactDescriptor.parseQuietly(key));
    }

    public Node findNode(String key, ArtifactDescriptor ad) throws BuildException {
        Node node = null;
        if (key != null) {
            node = this.findFirst(key, true);
        }
        if (node == null && ad != null) {
            node = this.findNode(ad);
        }
        if (node == null) {
            throw new BuildException("Artifact with pattern " + (key != null ? key : ad) + " was not found in graph");
        }
        return node;
    }
}

