/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.graph.DependencyUtils;
import org.nuxeo.build.maven.graph.Graph;

public class Node
implements DependencyNode {
    protected final Graph graph;
    protected final String id;
    @Deprecated
    private List<char[]> acceptedCategories;
    private List<DependencyNode> parents = new ArrayList<DependencyNode>();
    protected DependencyNode dependencyNode;

    @Deprecated
    public List<char[]> getAcceptedCategories() {
        if (this.acceptedCategories == null) {
            this.acceptedCategories = new ArrayList<char[]>();
        }
        return this.acceptedCategories;
    }

    public static String genNodeId(org.apache.maven.artifact.Artifact artifact) {
        return Node.genNodeId(RepositoryUtils.toDependency((org.apache.maven.artifact.Artifact)artifact, null));
    }

    public static String genNodeId(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        String scope = dependency.getScope();
        return Node.genNodeId(artifact, scope);
    }

    public static String genNodeId(Artifact artifact, String scope) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append(':').append(artifact.getArtifactId());
        sb.append(':').append(artifact.getBaseVersion());
        sb.append(':').append(artifact.getExtension());
        sb.append(':');
        if (artifact.getClassifier() != null) {
            sb.append(artifact.getClassifier());
        }
        sb.append(':').append(scope);
        return sb.toString();
    }

    public static String genNodeId(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency != null) {
            return Node.genNodeId(dependency);
        }
        return Node.genNodeId(node.getArtifact(), "");
    }

    public Node(Node node) {
        this.dependencyNode = node.dependencyNode;
        this.id = node.id;
        this.graph = node.graph;
        this.acceptedCategories = node.acceptedCategories;
        this.parents = node.parents;
    }

    public Node(Graph graph, DependencyNode dependencyNode) {
        this.graph = graph;
        this.dependencyNode = dependencyNode;
        this.id = Node.genNodeId(dependencyNode);
    }

    public org.apache.maven.artifact.Artifact getMavenArtifact() {
        return DependencyUtils.toMavenArtifact(this.getDependency());
    }

    public File getFile() {
        File file = this.getArtifact().getFile();
        if (file == null) {
            try {
                file = DependencyUtils.resolve(this.getArtifact()).getFile();
            }
            catch (ArtifactResolutionException e) {
                AntClient.getInstance().log(e.getMessage(), (Throwable)e, 0);
                return null;
            }
        }
        return file;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return this.id.equals(((Node)obj).id);
        }
        if (obj instanceof DependencyNode) {
            return this.dependencyNode.equals(obj) || this.id.equals(Node.genNodeId((DependencyNode)obj));
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.dependencyNode.toString();
    }

    @Deprecated
    public void setAcceptedCategory(char[] pattern) {
        this.getAcceptedCategories().add(pattern);
    }

    @Deprecated
    public boolean isAcceptedCategory(List<char[]> patterns) {
        for (char[] pattern : patterns) {
            if (!this.getAcceptedCategories().contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<DependencyNode> getChildren() {
        return this.dependencyNode.getChildren();
    }

    public Dependency getDependency() {
        return this.dependencyNode.getDependency();
    }

    public void setArtifact(Artifact artifact) {
        this.dependencyNode.setArtifact(artifact);
    }

    public List<? extends Artifact> getRelocations() {
        return this.dependencyNode.getRelocations();
    }

    public Collection<? extends Artifact> getAliases() {
        return this.dependencyNode.getAliases();
    }

    public VersionConstraint getVersionConstraint() {
        return this.dependencyNode.getVersionConstraint();
    }

    public Version getVersion() {
        return this.dependencyNode.getVersion();
    }

    public void setScope(String scope) {
        this.dependencyNode.setScope(scope);
    }

    public List<RemoteRepository> getRepositories() {
        return this.dependencyNode.getRepositories();
    }

    public String getRequestContext() {
        return this.dependencyNode.getRequestContext();
    }

    public void setRequestContext(String context) {
        this.dependencyNode.setRequestContext(context);
    }

    public Map<?, ?> getData() {
        return this.dependencyNode.getData();
    }

    public void setData(Object key, Object value) {
        this.dependencyNode.setData(key, value);
    }

    public boolean accept(DependencyVisitor visitor) {
        return this.dependencyNode.accept(visitor);
    }

    @Deprecated
    public List<DependencyNode> getParents() {
        return this.parents;
    }

    public void addParent(Node node) {
        this.parents.add(node);
    }

    public void setChildren(List<DependencyNode> children) {
        this.dependencyNode.setChildren(children);
    }

    public void setOptional(Boolean optional) {
        this.dependencyNode.setOptional(optional);
    }

    public int getManagedBits() {
        return this.dependencyNode.getManagedBits();
    }

    public void setData(Map<Object, Object> data) {
        this.dependencyNode.setData(data);
    }

    public Artifact getArtifact() {
        return this.dependencyNode.getArtifact();
    }

    public void setManagedBits(int managedBits) {
        ((DefaultDependencyNode)this.dependencyNode).setManagedBits(managedBits);
    }

    public DependencyNode getDependencyNode() {
        return this.dependencyNode;
    }
}

