/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.graph.AbstractDependencyVisitor;
import org.nuxeo.build.maven.graph.Node;

public class TreePrinterDependencyVisitor
extends AbstractDependencyVisitor {
    public static final String TAB_STR = " |-- ";
    protected String tabs = "";
    protected int format;
    protected OutputStream output;
    protected Map<String, DependencyNode> dependencyMap = new HashMap<String, DependencyNode>();
    protected Map<String, List<Dependency>> directDepsByArtifact = new HashMap<String, List<Dependency>>();

    public TreePrinterDependencyVisitor(OutputStream output, int format, List<String> scopes, List<Node> roots) {
        super(scopes);
        this.output = output;
        this.format = format;
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        for (Node node : roots) {
            node.accept((DependencyVisitor)nlg);
        }
        for (Node node : nlg.getNodes()) {
            this.dependencyMap.put(node.getArtifact().toString(), node);
        }
    }

    @Override
    protected void doVisit(DependencyNode node, boolean newNode) {
        try {
            this.print(node);
            if (newNode) {
                this.addMissingChildren(node);
            }
            this.incTabs();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMissingChildren(DependencyNode node) {
        AntBuildMojo mojo = AntBuildMojo.getInstance();
        this.incTabs();
        try {
            List directDeps = this.directDepsByArtifact.get(node.getArtifact().toString());
            if (directDeps == null) {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(node.getArtifact(), mojo.getRemoteRepositories(), null);
                ArtifactDescriptorResult descriptorResult = mojo.getSystem().readArtifactDescriptor((RepositorySystemSession)mojo.getSession(), descriptorRequest);
                directDeps = descriptorResult.getDependencies();
            }
            for (Dependency dependency : directDeps) {
                String version;
                String managedVersion;
                boolean removed = true;
                if ("test".equals(dependency.getScope()) && !"test".equals(node.getDependency().getScope())) continue;
                for (DependencyNode childNode : node.getChildren()) {
                    if (!childNode.getArtifact().toString().equals(dependency.getArtifact().toString())) continue;
                    removed = false;
                }
                if (!removed) continue;
                DependencyNode childNode = this.dependencyMap.get(dependency.getArtifact().toString());
                if (childNode == null) {
                    AntClient.getInstance().log("Ignored dependency " + dependency + " not in graph", 4);
                    continue;
                }
                int managedBits = 0;
                childNode = new DefaultDependencyNode(childNode);
                childNode.setScope(childNode.getDependency().getScope());
                String managedScope = dependency.getScope();
                String scope = childNode.getDependency().getScope();
                if (!managedScope.equals(scope)) {
                    managedBits |= 2;
                    childNode.setData((Object)"premanaged.scope", (Object)managedScope);
                }
                if (!(managedVersion = dependency.getArtifact().getBaseVersion()).equals(version = childNode.getArtifact().getBaseVersion())) {
                    managedBits |= 1;
                    childNode.setData((Object)"premanaged.version", (Object)managedVersion);
                }
                ((DefaultDependencyNode)childNode).setManagedBits(managedBits);
                childNode.setChildren(Collections.emptyList());
                if (node.getChildren().isEmpty()) {
                    node.setChildren(new ArrayList());
                }
                node.getChildren().add(childNode);
                this.setVisited(childNode);
            }
        }
        catch (ArtifactDescriptorException e) {
            AntClient.getInstance().log(e.getMessage(), (Throwable)e, 0);
        }
        finally {
            this.decTabs();
        }
    }

    protected void incTabs() {
        this.tabs = this.tabs + TAB_STR;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        boolean visit = super.visitLeave(node);
        if (!this.ignores.contains(node)) {
            this.decTabs();
        }
        return visit;
    }

    protected void decTabs() {
        this.tabs = this.tabs.substring(0, this.tabs.length() - TAB_STR.length());
    }

    protected void print(DependencyNode node) throws UnsupportedEncodingException, IOException {
        String toString = this.tabs + this.toString(node) + System.getProperty("line.separator");
        this.output.write(toString.getBytes(AntBuildMojo.getInstance().getEncoding()));
    }

    public String toString(DependencyNode node) {
        DependencyNode winner;
        String premanaged;
        Artifact artifact = node.getArtifact();
        Dependency dependency = node.getDependency();
        StringBuilder sb = new StringBuilder();
        switch (this.format) {
            case 1: {
                sb.append(artifact.getFile().getName());
                sb.append('=');
            }
            case 0: {
                sb.append(artifact.getGroupId());
                sb.append(':').append(artifact.getArtifactId());
                sb.append(':').append(artifact.getVersion());
                sb.append(':').append(artifact.getExtension());
                sb.append(':').append(artifact.getClassifier());
                sb.append(':').append(dependency.getScope());
                break;
            }
            default: {
                return "Unknown format: " + this.format + "!";
            }
        }
        if (node.getDependency().isOptional()) {
            sb.append(" [optional]");
        }
        if ((premanaged = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node)) != null && !premanaged.equals(artifact.getBaseVersion())) {
            sb.append(" (version managed from ").append(premanaged).append(")");
        }
        if ((premanaged = DependencyManagerUtils.getPremanagedScope((DependencyNode)node)) != null && !premanaged.equals(dependency.getScope())) {
            sb.append(" (scope managed from ").append(premanaged).append(")");
        }
        if ((winner = (DependencyNode)node.getData().get("conflict.winner")) != null && !ArtifactIdUtils.equalsId((Artifact)artifact, (Artifact)winner.getArtifact())) {
            Artifact w = winner.getArtifact();
            sb.append(" (superseded by ");
            if (ArtifactIdUtils.toVersionlessId((Artifact)artifact).equals(ArtifactIdUtils.toVersionlessId((Artifact)w))) {
                sb.append(w.getVersion());
            } else {
                sb.append(w);
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

