/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import java.util.Collections;
import java.util.Iterator;
import org.apache.maven.MavenArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Extension;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultExtensionManager
implements ExtensionManager,
Contextualizable {
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource artifactMetadataSource;
    private PlexusContainer container;
    private ArtifactFilter artifactFilter = MavenArtifactFilterManager.createStandardFilter();

    public void addExtension(Extension extension, MavenProject project, ArtifactRepository localRepository) throws ArtifactResolutionException, PlexusContainerException, ArtifactNotFoundException {
        String extensionId = ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId());
        Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(extensionId);
        if (artifact != null) {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(Collections.singleton(artifact), project.getArtifact(), localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, this.artifactFilter);
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                a = project.replaceWithActiveArtifact(a);
                this.container.addJarResource(a.getFile());
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

