/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.io.IOException;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;

public class FileProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource(new EnvarBasedValueSource());
            }
            catch (IOException e) {
                // empty catch block
            }
            interpolator.addValueSource(new MapBasedValueSource(System.getProperties()));
            if (StringUtils.isNotEmpty(fileString)) {
                fileString = StringUtils.replace(interpolator.interpolate(fileString, ""), "\\", "/");
                return FileUtils.fileExists(fileString);
            }
            fileString = actFile.getMissing();
            if (StringUtils.isNotEmpty(fileString)) {
                return !FileUtils.fileExists(fileString = StringUtils.replace(interpolator.interpolate(fileString, ""), "\\", "/"));
            }
        }
        return false;
    }
}

