/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.graph.AttachmentNode;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactFile
extends FileResource {
    protected Node node;
    public String key;
    public boolean strict;
    public String classifier;

    public void setKey(String pattern) {
        int p = pattern.lastIndexOf(59);
        if (p > -1) {
            this.key = pattern.substring(0, p);
            this.classifier = pattern.substring(p + 1);
        } else {
            this.key = pattern;
        }
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Node getNode() {
        if (this.node == null) {
            if (this.key.indexOf(58) == -1) {
                ArtifactDescriptor ad = new ArtifactDescriptor();
                ad.artifactId = this.key;
                this.node = MavenClient.getInstance().getGraph().findNode(ad);
            } else {
                this.node = MavenClient.getInstance().getGraph().findFirst(this.key);
            }
            if (this.node == null) {
                throw new BuildException("Artifact with pattern " + this.key + " was not found in graph");
            }
            if (this.classifier != null) {
                this.node = new AttachmentNode(this.node, this.classifier);
            }
        }
        return this.node;
    }

    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        return this.getNode().getFile();
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.getFile().getParentFile();
    }
}

