/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.Project;
import org.nuxeo.build.ant.artifact.ArtifactFile;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactSetParser {
    protected Project project;
    protected AntProfileManager profileMgr;

    public ArtifactSetParser(Project project) {
        this.project = project;
        this.profileMgr = MavenClient.getInstance().getAntProfileManager();
    }

    public void parse(File src, Collection<Node> nodes) throws IOException {
        this.parse(new BufferedReader(new FileReader(src)), nodes);
    }

    public void parse(BufferedReader reader, Collection<Node> nodes) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                line = reader.readLine();
                continue;
            }
            if ((line = this.project.replaceProperties(line)).startsWith("?")) {
                String profile = line.substring(1).trim();
                if (profile.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                if (this.profileMgr.isProfileActive(profile)) {
                    line = reader.readLine();
                    continue;
                }
                this.readToNextActiveProfile(reader);
            } else if (line.startsWith("@")) {
                File file = this.project.resolveFile(line.substring(1).trim());
                this.parse(file, nodes);
            } else if (!line.startsWith("!")) {
                int p = line.lastIndexOf(63);
                if (p > -1) {
                    List<String> profiles = this.split(line.substring(p + 1), ',');
                    if (!this.profileMgr.isAnyProfileActive(profiles)) {
                        line = reader.readLine();
                        continue;
                    }
                    line = line.substring(0, p);
                }
                ArtifactFile af = new ArtifactFile();
                af.setKey(line);
                nodes.add(af.getNode());
            }
            line = reader.readLine();
        }
    }

    protected String readToNextActiveProfile(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).startsWith("?")) {
                String profile = line.substring(1).trim();
                if (!this.profileMgr.isProfileActive(profile)) {
                    return this.readToNextActiveProfile(reader);
                }
                return profile;
            }
            line = reader.readLine();
        }
        return null;
    }

    protected List<String> split(String text, char ch) {
        ArrayList<String> result = new ArrayList<String>();
        int p = 0;
        int q = text.indexOf(ch, p);
        while (q > -1) {
            result.add(text.substring(p, q).trim());
            p = q + 1;
            q = text.indexOf(ch, p);
        }
        if (p == 0) {
            result.add(text.trim());
        } else {
            result.add(text.substring(p).trim());
        }
        return result;
    }
}

