/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.graph.Node;

public class AttachArtifactTask
extends Task {
    private File file;
    private String classifier;
    private String type;
    private String target;

    public void setFile(File file) {
        this.file = file;
    }

    public void setClassifier(String classifier) {
        if (classifier != null && classifier.length() == 0) {
            classifier = null;
        }
        this.classifier = classifier;
    }

    public void setTarget(String artifactKey) {
        this.target = artifactKey;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void execute() throws BuildException {
        MavenClient maven = MavenClient.getInstance();
        if (this.target == null) {
            throw new BuildException("Target artifact not set");
        }
        final Node node = maven.getGraph().findFirst(this.target, true);
        if (node == null) {
            throw new BuildException("No such artofact found: " + this.target);
        }
        if (this.classifier == null) {
            if (this.type != null) {
                throw new BuildException("type is set but classifier is not set");
            }
            this.log("Attaching main file " + this.file + " to artifact " + this.target, 2);
            node.getPom().getArtifact().setFile(this.file);
            ArtifactHandler handler = new ArtifactHandler(){

                public String getExtension() {
                    return AttachArtifactTask.this.getExtension(AttachArtifactTask.this.file.getName());
                }

                public String getDirectory() {
                    return null;
                }

                public String getClassifier() {
                    return null;
                }

                public String getPackaging() {
                    return node.getPom().getPackaging();
                }

                public boolean isIncludesDependencies() {
                    return false;
                }

                public String getLanguage() {
                    return null;
                }

                public boolean isAddedToClasspath() {
                    return false;
                }
            };
            node.getPom().getArtifact().setArtifactHandler(handler);
        } else {
            this.log("Attaching " + this.file + " as an attached artifact to " + this.target, 2);
            String type = this.type;
            if (type == null) {
                type = this.getExtension(this.file.getName());
            }
            maven.getProjectHelper().attachArtifact(node.getPom(), type, this.classifier, this.file);
        }
    }

    private String getExtension(String name) {
        int idx = name.lastIndexOf(46);
        return name.substring(idx + 1);
    }
}

