/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.artifact.SubGraph;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.GraphVizExporter;
import org.nuxeo.build.maven.graph.Node;

public class GraphExportTask
extends Task {
    public File file;
    public String nodeColor;
    public String edgeColor;
    public List<SubGraph> graphs = new ArrayList<SubGraph>();

    public void setFile(File file) {
        this.file = file;
    }

    public void addGraph(SubGraph graph) {
        this.graphs.add(graph);
    }

    public void setNodeColor(String color) {
        this.nodeColor = color;
    }

    public void setEdgeColor(String color) {
        this.edgeColor = color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        try {
            String name = this.file.getName();
            if (name.endsWith(".png")) {
                this.exportPng();
                return;
            }
            if (!name.endsWith(".txt") && !name.endsWith(".xml")) return;
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public void exportPng() throws Exception {
        Graph graph = MavenClient.getInstance().getGraph();
        FileOutputStream out = new FileOutputStream(this.file);
        GraphVizExporter gv = GraphVizExporter.createPng(out);
        if (this.nodeColor != null) {
            gv.setDefaultNodeColor(this.nodeColor);
        }
        if (this.edgeColor != null) {
            gv.setDefaultEdgeColor(this.nodeColor);
        }
        if (this.graphs.isEmpty()) {
            gv.process(graph);
        } else {
            HashSet<Node> nodes = new HashSet<Node>();
            for (SubGraph subg : this.graphs) {
                Collection<Node> subnodes = subg.getNodes();
                if (subg.nodeColor != null || subg.edgeColor != null) {
                    gv.setColors(subnodes, subg.nodeColor, subg.edgeColor);
                }
                nodes.addAll(subnodes);
            }
            gv.process(nodes);
        }
        gv.close();
    }

    public void exportXml() throws Exception {
    }

    public void exportText() throws Exception {
    }
}

