/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.artifact.ArtifactKey;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.graph.Node;

public class GraphTask
extends Task {
    protected List<ArtifactKey> selects;
    protected List<ArtifactKey> resolves;
    protected String src;
    protected Expand expand;

    public void setResolve(String resolve) {
        if (this.resolves == null) {
            this.resolves = new ArrayList<ArtifactKey>();
        }
        this.resolves.add(new ArtifactKey(resolve));
    }

    public void setSelect(String select) {
        if (this.selects == null) {
            this.selects = new ArrayList<ArtifactKey>();
        }
        this.selects.add(new ArtifactKey(select));
    }

    public void setSrc(String file) {
        this.src = file;
    }

    public void addExpand(Expand expand) {
        this.expand = expand;
    }

    public void addResolve(ArtifactKey artifact) {
        if (this.resolves == null) {
            this.resolves = new ArrayList<ArtifactKey>();
        }
        this.resolves.add(artifact);
    }

    public void addSelect(ArtifactKey artifact) {
        if (this.selects == null) {
            this.selects = new ArrayList<ArtifactKey>();
        }
        this.selects.add(artifact);
    }

    public void execute() throws BuildException {
        block13: {
            MavenClient maven;
            block12: {
                maven = MavenClient.getInstance();
                if (this.src != null) {
                    if (this.resolves == null) {
                        this.resolves = new ArrayList<ArtifactKey>();
                    }
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(this.src));
                        String line = reader.readLine();
                        while (line != null) {
                            line = this.getProject().replaceProperties(line.trim());
                            this.resolves.add(new ArtifactKey(line));
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new BuildException("Failed to import file: " + this.src, e);
                    }
                }
                if (this.resolves == null) break block12;
                for (ArtifactKey resolve : this.resolves) {
                    ArtifactDescriptor ad = new ArtifactDescriptor(resolve.pattern);
                    Artifact arti = GraphTask.readArtifact(ad);
                    try {
                        Node node = maven.getGraph().getRootNode(arti);
                        if (this.expand == null) continue;
                        if (this.expand.filter != null) {
                            node.expand(this.expand.level, CompositeFilter.compact(this.expand.filter));
                            continue;
                        }
                        node.expand(this.expand.level, null);
                    }
                    catch (ArtifactNotFoundException e) {
                        throw new BuildException("Root artifact cannot be found: " + arti, e);
                    }
                }
                break block13;
            }
            if (this.selects == null) break block13;
            for (ArtifactKey select : this.selects) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                AndFilter andf = new AndFilter();
                andf.addFiltersFromDescriptor(new ArtifactDescriptor(select.pattern));
                maven.getGraph().collectNodes(nodes, andf);
                if (this.expand == null) continue;
                for (Node node : nodes) {
                    if (this.expand.filter != null) {
                        node.expand(this.expand.level, CompositeFilter.compact(this.expand.filter));
                        continue;
                    }
                    node.expand(this.expand.level, null);
                }
            }
        }
    }

    public static Artifact readArtifact(ArtifactDescriptor artifactDescriptor) {
        return MavenClient.getInstance().getArtifactFactory().createBuildArtifact(artifactDescriptor.groupId, artifactDescriptor.artifactId, artifactDescriptor.version, artifactDescriptor.type);
    }
}

