/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Sequential;
import org.nuxeo.build.ant.artifact.Repositories;
import org.nuxeo.build.ant.artifact.Repository;
import org.nuxeo.build.maven.MavenClient;

public class SettingsTask
extends Sequential {
    public File file;
    public Repositories repos;
    public boolean offline = false;
    public boolean interactive = false;
    public boolean debug = false;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFile(File settings) {
        this.file = settings;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void addRepositories(Repositories repos) {
        this.repos = repos;
    }

    public void execute() throws BuildException {
        MavenClient maven = MavenClient.getInstance();
        maven.setOffline(this.offline);
        maven.setInteractiveMode(this.interactive);
        if (this.debug) {
            if (maven.getLogger() == null) {
                maven.setLogger(new MavenEmbedderConsoleLogger());
            }
            maven.getLogger().setThreshold(0);
        } else {
            maven.setLogger(null);
        }
        try {
            if (!maven.isStarted()) {
                maven.setSettings(this.file);
                maven.start();
            }
        }
        catch (Exception e) {
            throw new BuildException("Failed to start maven", e);
        }
        for (Repository repo : this.repos.getRepositories()) {
            maven.addRemoteRepository(this.convertRepositoryToMavenModel(repo));
        }
    }

    public org.apache.maven.model.Repository convertRepositoryToMavenModel(Repository repo) {
        org.apache.maven.model.Repository r = new org.apache.maven.model.Repository();
        r.setId(repo.id);
        r.setLayout(repo.layout);
        r.setName(repo.name);
        r.setUrl(repo.url);
        RepositoryPolicy policy = new RepositoryPolicy();
        if (repo.snapshotsPolicy == null) {
            policy.setEnabled(true);
        } else {
            policy.setEnabled(repo.snapshotsPolicy.enabled);
            policy.setChecksumPolicy(repo.snapshotsPolicy.checksumPolicy);
            policy.setUpdatePolicy(repo.snapshotsPolicy.udpatePolicy);
            policy.setModelEncoding(repo.snapshotsPolicy.modelEncoding);
        }
        r.setSnapshots(policy);
        policy = new RepositoryPolicy();
        if (repo.releasesPolicy == null) {
            policy.setEnabled(true);
        } else {
            policy.setEnabled(repo.releasesPolicy.enabled);
            policy.setChecksumPolicy(repo.releasesPolicy.checksumPolicy);
            policy.setUpdatePolicy(repo.releasesPolicy.udpatePolicy);
            policy.setModelEncoding(repo.releasesPolicy.modelEncoding);
        }
        r.setReleases(policy);
        return r;
    }
}

