/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.tools.ant.util.FileNameMapper;
import org.nuxeo.build.maven.MavenClient;

public class VersionMapper
implements FileNameMapper {
    private Pattern from;
    private String to;

    public String[] mapFileName(String sourceFileName) {
        Matcher matcher;
        if (this.from != null && !(matcher = this.from.matcher(sourceFileName)).matches()) {
            return new String[]{sourceFileName};
        }
        Artifact artifact = MavenClient.getInstance().getGraph().getArtifactByFile(sourceFileName);
        if (artifact != null) {
            String ext = null;
            int p = sourceFileName.lastIndexOf(46);
            if (p > -1) {
                ext = sourceFileName.substring(p);
            }
            String path = artifact.getArtifactId();
            if (this.to != null) {
                path = path + this.to;
            }
            if (artifact.getClassifier() != null) {
                path = path + "-" + artifact.getClassifier();
            }
            if (ext != null) {
                path = path + ext;
            }
            return new String[]{path};
        }
        return new String[]{sourceFileName};
    }

    public void setFrom(String from) {
        if (from != null) {
            this.from = Pattern.compile(from);
        }
    }

    public void setTo(String to) {
        this.to = to;
    }
}

