/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFilter
implements Filter {
    protected List<Filter> filters = new ArrayList<Filter>();

    public CompositeFilter() {
    }

    public CompositeFilter(List<Filter> filters) {
        this.filters.addAll(filters);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void addFilters(List<Filter> filters) {
        this.filters.addAll(filters);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public void addFiltersFromPattern(String pattern) {
        this.addFiltersFromDescriptor(new ArtifactDescriptor(pattern));
    }

    public void addFiltersFromDescriptor(ArtifactDescriptor ad) {
        if (ad.groupId != null && !ad.groupId.equals("*")) {
            this.addFilter(new GroupIdFilter(ad.groupId));
        }
        if (ad.artifactId != null && !ad.artifactId.equals("*")) {
            this.addFilter(new ArtifactIdFilter(ad.artifactId));
        }
        if (ad.version != null && !ad.version.equals("*")) {
            this.addFilter(new VersionFilter(ad.version));
        }
        if (ad.type != null && !ad.type.equals("*")) {
            this.addFilter(new TypeFilter(ad.type));
        }
        if (ad.classifier != null && !ad.classifier.equals("*")) {
            this.addFilter(new ClassifierFilter(ad.classifier));
        }
        if (ad.scope != null && !ad.scope.equals("*")) {
            this.addFilter(new ScopeFilter(ad.scope));
        }
    }

    public static Filter compact(CompositeFilter filter) {
        Filter result = filter;
        CompositeFilter cf = filter;
        if (cf.filters.size() == 1 && (result = cf.filters.get(0)) instanceof CompositeFilter) {
            result = CompositeFilter.compact(result);
        }
        return result;
    }
}

