/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.SegmentMatch;
import org.nuxeo.build.maven.graph.Edge;

public class ScopeFilter
implements Filter {
    protected SegmentMatch matcher;

    public ScopeFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public ScopeFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    public boolean match(String segment) {
        return this.matcher.match(segment);
    }

    public boolean accept(Dependency dep) {
        String scope = dep.getScope();
        if (scope == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(dep.getScope());
    }

    public boolean accept(Edge edge) {
        if (edge.scope == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(edge.scope);
    }

    public boolean accept(Artifact artifact) {
        String scope = artifact.getScope();
        if (scope == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(scope);
    }
}

