/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.GraphVisitor;
import org.nuxeo.build.maven.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphVisitor
implements GraphVisitor {
    protected Set<Node> visitedNodes = new HashSet<Node>();

    public void process(Graph graph) {
        this.process(graph.getRoots());
    }

    public void process(Collection<Node> roots) {
        for (Node root : roots) {
            this.visit(root);
        }
    }

    public boolean visit(Node node) {
        if (this.visitedNodes.contains(node.id)) {
            return false;
        }
        this.visitedNodes.add(node);
        if (this.visitNode(node)) {
            this.visitEdges(node);
        }
        return true;
    }

    public void visitEdges(Node node) {
        for (Edge edge : node.getEdgesOut()) {
            if (!this.visitEdge(edge)) continue;
            this.visit(edge.dst);
        }
    }

    @Override
    public abstract boolean visitNode(Node var1);

    @Override
    public abstract boolean visitEdge(Edge var1);
}

