/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    protected Graph graph;
    protected String id;
    protected Artifact artifact;
    protected List<Edge> edgesIn;
    protected List<Edge> edgesOut;
    protected MavenProject pom;
    private boolean isExpanded;

    public static String createNodeId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + ':' + artifact.getType() + ':';
    }

    public Node(Node node) {
        this.graph = node.graph;
        this.id = node.id;
        this.artifact = node.artifact;
        this.edgesIn = node.edgesIn;
        this.edgesOut = node.edgesOut;
        this.pom = node.pom;
        this.isExpanded = node.isExpanded;
    }

    public Node(Graph graph, MavenProject pom, Artifact artifact) {
        this(graph, pom, artifact, Node.createNodeId(artifact));
    }

    protected Node(Graph graph, MavenProject pom, Artifact artifact, String id) {
        this.graph = graph;
        this.id = id;
        this.artifact = artifact;
        this.pom = pom;
        this.edgesIn = new ArrayList<Edge>();
        this.edgesOut = new ArrayList<Edge>();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public File getFile() {
        this.resolveIfNeeded();
        File file = this.artifact.getFile();
        if (file != null) {
            this.graph.file2artifacts.put(file.getName(), this.artifact);
        }
        return file;
    }

    public File getFile(String classifier) {
        this.resolveIfNeeded();
        Artifact ca = this.graph.maven.getArtifactFactory().createArtifactWithClassifier(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), this.artifact.getType(), classifier);
        try {
            this.graph.maven.resolve(ca);
            File file = ca.getFile();
            if (file != null) {
                this.graph.file2artifacts.put(file.getAbsolutePath(), ca);
            }
            return file;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isRoot() {
        return this.edgesIn.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public List<Edge> getEdgesOut() {
        return this.edgesOut;
    }

    public List<Edge> getEdgesIn() {
        return this.edgesIn;
    }

    public void addEdgeIn(Edge edge) {
        this.edgesIn.add(edge);
    }

    public void addEdgeOut(Edge edge) {
        this.edgesOut.add(edge);
    }

    public MavenProject getPom() {
        this.resolveIfNeeded();
        return this.pom;
    }

    public MavenProject getPomIfAlreadyLoaded() {
        return this.pom;
    }

    public void expand(int recurse, Filter filter) {
        if (this.isExpanded) {
            return;
        }
        this.isExpanded = true;
        this.resolveIfNeeded();
        if (this.pom == null) {
            return;
        }
        if (recurse > 0) {
            if ("pom".equals(this.artifact.getType())) {
                this.loadDependencies(recurse - 1, this.pom.getDependencyManagement().getDependencies(), filter);
            } else {
                this.loadDependencies(recurse - 1, this.pom.getDependencies(), filter);
            }
        }
    }

    public void expand(Filter filter) {
        this.expand(0, filter);
    }

    public void expandAll(Filter filter) {
        this.expand(Integer.MAX_VALUE, filter);
    }

    public List<Node> getTrail() {
        if (this.edgesIn.isEmpty()) {
            ArrayList<Node> result = new ArrayList<Node>();
            result.add(this);
            return result;
        }
        Edge edge = this.edgesIn.get(0);
        List<Node> path = edge.src.getTrail();
        path.add(this);
        return path;
    }

    public void resolveIfNeeded() {
        try {
            this.graph.getResolver().resolve(this);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Artifact not found: " + this.artifact.getId(), e);
        }
    }

    protected void loadDependencies(int recurse, List<Dependency> deps, Filter filter) {
        this.resolveIfNeeded();
        ArtifactFactory factory = this.graph.getMaven().getArtifactFactory();
        MavenProject pom = this.getPom();
        if (pom == null) {
            return;
        }
        for (Dependency d : deps) {
            if (filter != null && !filter.accept(d)) continue;
            Artifact a = factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion(d.getVersion()), d.getType(), d.getClassifier(), d.getScope(), false);
            assert (a.getScope().equals(d.getScope()));
            Node newNode = null;
            try {
                newNode = this.graph.getNode(a);
            }
            catch (ArtifactNotFoundException e) {
                throw new RuntimeException("Unable to find dependency: " + a + ". Trail: " + this.getTrail(), e);
            }
            Edge edge = new Edge(this, newNode, d.getScope(), d.isOptional());
            this.addEdgeOut(edge);
            newNode.addEdgeIn(edge);
            if (recurse <= 0) continue;
            newNode.expand(recurse, filter);
        }
    }

    public void collectNodes(Collection<Node> nodes, Filter filter) {
        for (Edge edge : this.edgesOut) {
            if (!filter.accept(edge)) continue;
            nodes.add(edge.dst);
        }
    }

    public void collectNodes(Collection<Node> nodes) {
        for (Edge edge : this.edgesOut) {
            nodes.add(edge.dst);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return ((Node)obj).id.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

