/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class Resolver {
    protected Graph graph;

    public Resolver(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void resolve(Node node) throws ArtifactNotFoundException {
        Relocation reloc;
        DistributionManagement dm;
        if (node.pom != null || node.artifact.isResolved()) {
            return;
        }
        Artifact artifact = node.artifact;
        MavenProject pom = this.loadPom(artifact);
        if (pom != null && (dm = pom.getDistributionManagement()) != null && (reloc = dm.getRelocation()) != null) {
            Artifact orig = artifact;
            String artifactId = reloc.getArtifactId();
            String groupId = reloc.getGroupId();
            String version = reloc.getVersion();
            if (artifactId == null) {
                artifactId = artifact.getArtifactId();
            }
            if (groupId == null) {
                groupId = artifact.getGroupId();
            }
            if (version == null) {
                version = artifact.getVersion();
            }
            node.artifact = this.graph.maven.getArtifactFactory().createArtifact(groupId, artifactId, version, artifact.getScope(), artifact.getType());
            System.out.println("Artifact " + orig + " was relocated to:  " + artifact);
            this.resolve(node);
        }
        try {
            if (!artifact.isResolved()) {
                this.graph.maven.resolve(artifact);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        node.artifact = artifact;
        node.pom = pom;
    }

    public MavenProject loadPom(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.graph.maven.getProjectBuilder().buildFromRepository(this.graph.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.graph.maven.getRemoteRepositories(), this.graph.maven.getLocalRepository());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

