/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.nuxeo.build.swing.ArtifactTable;
import org.nuxeo.build.swing.SpringUtilities;

public class ProfilesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected ArtifactTable table;
    protected JTable columnTable;
    protected ColumnsDataModel model;

    public ProfilesDialog(JFrame frame, ArtifactTable table) {
        super(frame);
        this.table = table;
        this.setTitle("Manage Profiles");
        this.setAlwaysOnTop(true);
        this.setContentPane(this.createContentPane());
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilesDialog.this.setVisible(false);
                ProfilesDialog.this.dispose();
            }
        }, stroke, 2);
        return rootPane;
    }

    protected Container createContentPane() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        List<String> cols = this.table.getModel().getColumns();
        HashSet<String> vcols = new HashSet<String>(this.table.getModel().getVisibleColumns());
        this.model = new ColumnsDataModel();
        for (String col : cols) {
            this.model.addColumn(col, vcols.contains(col) ? Boolean.TRUE : Boolean.FALSE);
        }
        this.columnTable = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.columnTable);
        JPanel btnPanel = new JPanel(new SpringLayout());
        JButton add = new JButton("Add");
        add.addActionListener(this);
        JButton remove = new JButton("Remove");
        remove.addActionListener(this);
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)btnPanel, "After");
        btnPanel.add(add);
        btnPanel.add(remove);
        SpringUtilities.makeCompactGrid(btnPanel, 2, 1, 5, 5, 5, 5);
        this.columnTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.columnTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if ("Add".equals(e.getActionCommand())) {
            String s = JOptionPane.showInputDialog(this, "Pofile Name: ", "Create profile", -1);
            if (s != null) {
                this.table.getModel().addColumn(s);
                this.model.addColumn(s, Boolean.TRUE);
            }
        } else {
            int[] rows = this.columnTable.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Column col = this.model.removeColumn(i);
                this.table.getModel().removeColumn(col.key);
            }
        }
    }

    public void setPreferredColumnWidths(JTable table, double[] percentages) {
        int i;
        Dimension tableDim = table.getPreferredSize();
        double total = 0.0;
        for (i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            total += percentages[i];
        }
        int len = table.getColumnModel().getColumnCount();
        for (i = 0; i < len; ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth((int)((double)tableDim.width * (percentages[i] / total)));
            System.out.println("888 " + column.getPreferredWidth());
        }
    }

    static class Column {
        String key;
        Boolean selected;

        public Column(String key, Boolean selected) {
            this.key = key;
            this.selected = selected;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ColumnsDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<Column> cols = new ArrayList<Column>();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.cols.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.cols.get((int)rowIndex).selected : this.cols.get((int)rowIndex).key;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                Column col = this.cols.get(rowIndex);
                col.selected = (Boolean)value;
                if (col.selected.booleanValue()) {
                    ProfilesDialog.this.table.getModel().getVisibleColumns().add(col.key);
                } else {
                    ProfilesDialog.this.table.getModel().getVisibleColumns().remove(col.key);
                }
                ProfilesDialog.this.table.getModel().fireTableStructureChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "" : "Profile";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void addColumn(String col, boolean selected) {
            this.cols.add(new Column(col, selected));
            this.fireTableDataChanged();
        }

        public Column removeColumn(int index) {
            Column col = this.cols.remove(index);
            this.fireTableDataChanged();
            return col;
        }

        public List<String> getSelectedColumns() {
            ArrayList<String> result = new ArrayList<String>();
            for (Column col : this.cols) {
                if (!col.selected.booleanValue()) continue;
                result.add(col.key);
            }
            return result;
        }
    }
}

