/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.swing.tree.ArtifactCellRenderer;
import org.nuxeo.build.swing.tree.CleanNuxeoProvider;
import org.nuxeo.build.swing.tree.DefaultNuxeoProvider;
import org.nuxeo.build.swing.tree.ItemProvider;
import org.nuxeo.build.util.IOUtils;

public class ArtifactTree
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    protected JTree tree;
    DefaultMutableTreeNode root;
    protected MavenClient maven;
    protected ItemProvider provider = ItemProvider.DEFAULT;

    public ArtifactTree() {
        super(0, true);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initializeMaven();
        JPanel pane = new JPanel(new BorderLayout(3, 3));
        JToolBar tbar = new JToolBar();
        final JComboBox<String> presets = new JComboBox<String>(new String[]{"Default", "Minimal"});
        presets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultNuxeoProvider provider = "Default".equals(presets.getSelectedItem()) ? new DefaultNuxeoProvider() : new CleanNuxeoProvider();
                ArtifactTree.this.setProvider(provider);
            }
        });
        tbar.add(presets);
        final JTextPane info = new JTextPane();
        info.setContentType("text/html");
        info.setEditable(false);
        info.setBorder(new EmptyBorder(5, 5, 5, 5));
        info.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                JFileChooser fc;
                int r;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (r = (fc = new JFileChooser()).showSaveDialog(ArtifactTree.this)) == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        IOUtils.copy(e.getURL(), file);
                    }
                    catch (Exception ee) {
                        JOptionPane.showMessageDialog(ArtifactTree.this, "Unable to copy url to file: " + file, "Error", 0);
                        ee.printStackTrace();
                    }
                }
            }
        });
        final JTextField addressBar = new JTextField();
        addressBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = addressBar.getText().trim();
                if (text.length() > 0) {
                    try {
                        Node node = ArtifactTree.this.maven.getGraph().addRootNode(text);
                        DefaultMutableTreeNode graphRoot = new DefaultMutableTreeNode(node);
                        int len = ArtifactTree.this.root.getChildCount();
                        for (int i = 0; i < len; ++i) {
                            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)ArtifactTree.this.root.getChildAt(i);
                            Node n = (Node)tn.getUserObject();
                            if (!node.equals(n)) continue;
                            return;
                        }
                        graphRoot.setAllowsChildren(ArtifactTree.this.provider.hasChildren(node));
                        ArtifactTree.this.root.add(graphRoot);
                        ArtifactTree.this.refresh();
                    }
                    catch (Exception ee) {
                        JOptionPane.showMessageDialog(ArtifactTree.this, "Unable to resolve artifact: " + text, "Error", 0);
                        ee.printStackTrace();
                    }
                }
            }
        });
        tbar.add(addressBar);
        this.root = new DefaultMutableTreeNode();
        this.tree = new JTree(this.root);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        ((DefaultTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new ArtifactCellRenderer(this));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object o;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)ArtifactTree.this.tree.getLastSelectedPathComponent();
                if (tn != null && (o = tn.getUserObject()) instanceof Node) {
                    Node node = (Node)tn.getUserObject();
                    info.setText(ArtifactTree.this.provider.getInfo(node));
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object o;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)ArtifactTree.this.tree.getLastSelectedPathComponent();
                if (tn != null && (o = tn.getUserObject()) instanceof Node) {
                    Node node = (Node)tn.getUserObject();
                    info.setText(ArtifactTree.this.provider.getInfo(node));
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)ArtifactTree.this.tree.getLastSelectedPathComponent();
                if (tn != null && tn.getChildCount() == 0) {
                    Node node = (Node)tn.getUserObject();
                    System.out.println("Lazy load node: " + node);
                    node.expand(1, null);
                    if (!node.getEdgesOut().isEmpty()) {
                        for (Edge edge : node.getEdgesOut()) {
                            if (!ArtifactTree.this.provider.accept(edge)) continue;
                            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode();
                            treeNode.setAllowsChildren(ArtifactTree.this.provider.hasChildren(node));
                            tn.add(new DefaultMutableTreeNode(edge.dst));
                        }
                        ArtifactTree.this.refresh(tn);
                    }
                }
            }
        });
        pane.add((Component)tbar, "First");
        pane.add((Component)new JScrollPane(this.tree), "Center");
        this.add(pane);
        this.add(new JScrollPane(info));
        this.setProvider(new DefaultNuxeoProvider());
    }

    public void refresh(TreeNode tn) {
        ((DefaultTreeModel)this.tree.getModel()).reload(tn);
    }

    public void refresh() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void setProvider(ItemProvider provider) {
        this.provider = provider;
        this.root.removeAllChildren();
        String[] roots = provider.getRoots();
        if (roots != null) {
            for (String root : roots) {
                try {
                    Node node = this.maven.getGraph().addRootNode(root);
                    DefaultMutableTreeNode graphRoot = new DefaultMutableTreeNode(node);
                    this.root.add(graphRoot);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to resolve artifact: " + root, "Error", 0);
                }
            }
            this.refresh();
        }
    }

    public ItemProvider getProvider() {
        return this.provider;
    }

    public void initializeMaven() {
        this.maven = MavenClient.getInstance();
        try {
            this.maven.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to start maven: " + e.getMessage(), "Error", 0);
            e.printStackTrace();
            return;
        }
        Repository repo = new Repository();
        repo.setId("nuxeo_public");
        repo.setName("Nuxeo Public Repository");
        repo.setLayout("default");
        repo.setUrl("http://maven.nuxeo.org/public");
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(false);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
        repo = new Repository();
        repo.setId("nuxeo_public_snapshot");
        repo.setName("Nuxeo Public Snapshot Repository");
        repo.setLayout("default");
        repo.setUrl("http://maven.nuxeo.org/public-snapshot");
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
        repo = new Repository();
        repo.setId("jboss");
        repo.setName("JBoss Repository");
        repo.setLayout("default");
        repo.setUrl("http://repository.jboss.com/maven2");
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(false);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
        repo = new Repository();
        repo.setId("ibiblio");
        repo.setName("IBiblio Mirror Repository");
        repo.setLayout("default");
        repo.setUrl("http://mirrors.ibiblio.org/pub/mirrors/maven2");
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setReleases(policy);
        policy = new RepositoryPolicy();
        policy.setEnabled(true);
        policy.setUpdatePolicy("never");
        policy.setChecksumPolicy("fail");
        repo.setSnapshots(policy);
        this.maven.addRemoteRepository(repo);
    }
}

