/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.codehaus.plexus.util.IOUtil;

public class IOUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = IOUtils.createBuffer(in.available());
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            IOUtil.copy(in, (OutputStream)out);
        }
        finally {
            in.close();
            out.close();
        }
    }

    public static void safeClose(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

