/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.ant.artifact.ArtifactSet;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.TrueFilter;
import org.nuxeo.build.maven.graph.AttachmentNode;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactDependencies
extends DataType
implements ResourceCollection {
    protected Graph graph = MavenClientFactory.getInstance().getGraph();
    protected Node node;
    protected List<Node> nodes;
    public String key;
    public int depth = 1;
    public ArtifactDescriptor ad = ArtifactDescriptor.emptyDescriptor();
    public Includes includes;
    public Excludes excludes;

    public void setDepth(String depth) {
        if ("all".equals(depth)) {
            this.depth = Integer.MAX_VALUE;
        } else {
            this.depth = Integer.parseInt(depth);
            if (this.depth == 0) {
                throw new IllegalArgumentException("0 is not a valid value for depth");
            }
        }
    }

    public void addExcludes(Excludes excludes) {
        if (this.excludes != null) {
            throw new BuildException("Found an Excludes that is defined more than once in an artifact dependencies");
        }
        this.excludes = excludes;
    }

    public void addIncludes(Includes includes) {
        if (this.includes != null) {
            throw new BuildException("Found an Includes that is defined more than once in an artifact dependencies");
        }
        this.includes = includes;
    }

    public void setKey(String pattern) {
        this.key = pattern;
    }

    public void setArtifactId(String artifactId) {
        this.ad.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.ad.groupId = groupId;
    }

    public void setType(String type) {
        this.ad.type = type;
    }

    public void setVersion(String version) {
        this.ad.version = version;
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = this.key != null ? this.graph.findFirst(this.key) : this.graph.findNode(this.ad);
            if (this.node == null) {
                throw new BuildException("Artifact with pattern " + (this.key != null ? this.key : this.ad) + " was not found in graph");
            }
            if (this.ad.classifier != null) {
                this.node = new AttachmentNode(this.node, this.ad.classifier);
            }
        }
        return this.node;
    }

    public List<Node> getNodes() {
        block7: {
            if (this.nodes != null) break block7;
            Filter filter = null;
            if (this.includes != null || this.excludes != null) {
                AndFilter andf = new AndFilter();
                if (this.includes != null) {
                    andf.addFilter(this.includes.getFilter());
                }
                if (this.excludes != null) {
                    andf.addFilter(this.excludes.getFilter());
                }
                filter = CompositeFilter.compact(andf);
            }
            this.graph.resolveDependencyTree(this.getNode(), new TrueFilter(), Integer.MAX_VALUE);
            this.nodes = new ArrayList<Node>();
            if (filter != null) {
                for (Edge edge : this.node.getEdgesOut()) {
                    if (!filter.accept(edge.out.getArtifact())) continue;
                    this.nodes.add(edge.out);
                }
            } else {
                for (Edge edge : this.node.getEdgesOut()) {
                    this.nodes.add(edge.out);
                }
            }
        }
        return this.nodes;
    }

    public Iterator<FileResource> iterator() {
        return ArtifactSet.createIterator(this.getNodes());
    }

    public int size() {
        return this.getNodes().size();
    }

    public boolean isFilesystemOnly() {
        return true;
    }
}

