/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.artifact.ExpandTask;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.NotFilter;
import org.nuxeo.build.maven.filter.VersionFilter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class NuxeoExpandTask
extends ExpandTask {
    private HashMap<String, Boolean> includedScopes = new HashMap();
    private boolean includeCompileScope = true;
    private boolean includeProvidedScope = false;
    private boolean includeRuntimeScope = true;
    private boolean includeTestScope = false;
    private boolean includeSystemScope = true;
    private String[] groupPrefixes = new String[]{"org.nuxeo"};

    public void setGroupPrefixes(String groupPrefixes) {
        ArrayList<String> prefixes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(groupPrefixes, ",");
        while (st.hasMoreTokens()) {
            prefixes.add(st.nextToken());
        }
        this.groupPrefixes = prefixes.toArray(new String[0]);
    }

    public NuxeoExpandTask() {
        this.setDepth("all");
    }

    @Override
    public void execute() throws BuildException {
        this.getIncludedScopes().put("compile", this.includeCompileScope);
        this.getIncludedScopes().put("provided", this.includeProvidedScope);
        this.getIncludedScopes().put("runtime", this.includeRuntimeScope);
        this.getIncludedScopes().put("test", this.includeTestScope);
        this.getIncludedScopes().put("system", this.includeSystemScope);
        this.filter.addFilter(new Filter(){

            @Override
            public boolean accept(Artifact artifact) {
                return true;
            }

            @Override
            public boolean accept(Edge edge) {
                if (edge.isOptional) {
                    return false;
                }
                if (edge.scope == null) {
                    MavenClientFactory.getLog().warn("Missing scope, set to compile : " + edge);
                    edge.scope = "compile";
                }
                return NuxeoExpandTask.this.getIncludedScopes().get(edge.scope);
            }

            @Override
            public boolean accept(Node node) {
                return true;
            }
        });
        this.filter.addFilter(new NotFilter(new VersionFilter("[*)")));
        this.filter.addFilter(new NotFilter(new GroupIdFilter("org.nuxeo.build")));
        super.execute();
    }

    @Override
    protected boolean acceptNode(Node node) {
        for (String prefix : this.groupPrefixes) {
            if (!node.getArtifact().getGroupId().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected HashMap<String, Boolean> getIncludedScopes() {
        return this.includedScopes;
    }

    public void setIncludeCompileScope(boolean includeCompileScope) {
        this.includeCompileScope = includeCompileScope;
    }

    public void setIncludeProvidedScope(boolean includeProvidedScope) {
        this.includeProvidedScope = includeProvidedScope;
    }

    public void setIncludeRuntimeScope(boolean includeRuntimeScope) {
        this.includeRuntimeScope = includeRuntimeScope;
    }

    public void setIncludeTestScope(boolean includeTestScope) {
        this.includeTestScope = includeTestScope;
    }

    public void setIncludeSystemScope(boolean includeSystemScope) {
        this.includeSystemScope = includeSystemScope;
    }
}

