/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.VersionManagement;

public class ArtifactDescriptor {
    public String groupId = null;
    public String artifactId = null;
    public String version = null;
    public String type = "jar";
    public String classifier = null;
    public String scope = "compile";

    public static ArtifactDescriptor emptyDescriptor() {
        ArtifactDescriptor ad = new ArtifactDescriptor();
        ad.scope = null;
        ad.type = null;
        return ad;
    }

    public ArtifactDescriptor() {
    }

    public ArtifactDescriptor(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public ArtifactDescriptor(String expr) {
        this.parse(expr);
    }

    public void parse(String expr) {
        String[] result = expr.split(":");
        if (result.length > 5) {
            String string = this.scope = "".equals(result[5]) ? "compile" : result[5];
        }
        if (result.length > 4) {
            String string = this.classifier = "".equals(result[4]) ? null : result[4];
        }
        if (result.length > 3) {
            String string = this.type = "".equals(result[3]) ? "jar" : result[3];
        }
        if (result.length > 2) {
            String string = this.version = "".equals(result[2]) ? null : result[2];
        }
        if (result.length > 1) {
            String string = this.artifactId = "".equals(result[1]) ? null : result[1];
        }
        if (result.length > 0) {
            this.groupId = "".equals(result[0]) ? null : result[0];
        }
    }

    public Artifact toBuildArtifact() {
        return MavenClientFactory.getInstance().getArtifactFactory().createBuildArtifact(this.groupId, this.artifactId, this.version, this.type);
    }

    public Artifact toArtifactWithClassifier() {
        return MavenClientFactory.getInstance().getArtifactFactory().createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
    }

    public String getNodeKeyPattern() {
        if (this.groupId != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.groupId);
            if (this.artifactId != null) {
                buf.append(':').append(this.artifactId);
                if (this.version != null) {
                    buf.append(':').append(this.version);
                    if (this.type != null) {
                        buf.append(':').append(this.type);
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        buf.append(':').append(this.version);
        buf.append(':').append(this.type);
        buf.append(':').append(this.classifier);
        buf.append(':').append(this.scope);
        return buf.toString();
    }

    public Artifact getArtifact() {
        MavenClient maven = MavenClientFactory.getInstance();
        if (this.version == null) {
            VersionManagement versionManagement = maven.getGraph().getVersionManagement();
            this.version = versionManagement.getVersion(this);
            if (this.version == null) {
                throw new BuildException("Version is required since not found in dependency management: " + this);
            }
        }
        Artifact artifact = maven.getArtifactFactory().createDependencyArtifact(this.groupId, this.artifactId, VersionRange.createFromVersion((String)this.version), this.type, this.classifier, this.scope);
        return artifact;
    }

    public Artifact getBuildArtifact() {
        return MavenClientFactory.getInstance().getArtifactFactory().createBuildArtifact(this.groupId, this.artifactId, this.version, this.type);
    }
}

