/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.BuildFailureException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.embedder.MavenEmbedderLoggerManager;
import org.apache.maven.embedder.PlexusLoggerAdapter;
import org.apache.maven.embedder.SummaryPluginDescriptor;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MissingProjectException;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenEmbedder {
    public static final String userHome = System.getProperty("user.home");
    protected Embedder embedder;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactRepositoryFactory artifactRepositoryFactory;
    protected MavenSettingsBuilder settingsBuilder;
    protected LifecycleExecutor lifecycleExecutor;
    protected WagonManager wagonManager;
    protected MavenXpp3Reader modelReader;
    protected MavenXpp3Writer modelWriter;
    protected ProfileManager profileManager;
    protected PluginDescriptorBuilder pluginDescriptorBuilder;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    protected Settings settings;
    protected ArtifactRepository localRepository;
    protected File localRepositoryDirectory = new File(userHome, ".m2/repository");
    protected ClassLoader classLoader;
    protected MavenEmbedderLogger logger;
    protected boolean interactiveMode;
    protected boolean offline;
    protected String globalChecksumPolicy;
    protected boolean alignWithUserInstallation;
    public static final String DEFAULT_LOCAL_REPO_ID = "local";
    public static final String DEFAULT_LAYOUT_ID = "default";

    public void setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setGlobalChecksumPolicy(String globalChecksumPolicy) {
        this.globalChecksumPolicy = globalChecksumPolicy;
    }

    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    public boolean isAlignWithUserInstallation() {
        return this.alignWithUserInstallation;
    }

    public void setAlignWithUserInstallation(boolean alignWithUserInstallation) {
        this.alignWithUserInstallation = alignWithUserInstallation;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public MavenEmbedderLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MavenEmbedderLogger logger) {
        this.logger = logger;
    }

    public Model readModel(File model) throws XmlPullParserException, FileNotFoundException, IOException {
        return this.modelReader.read((Reader)new FileReader(model));
    }

    public void writeModel(Writer writer, Model model) throws IOException {
        this.modelWriter.write(writer, model);
    }

    public MavenProject readProject(File mavenProject) throws ProjectBuildingException {
        return this.mavenProjectBuilder.build(mavenProject, this.localRepository, this.profileManager);
    }

    public MavenProject readProjectWithDependencies(File mavenProject, TransferListener transferListener) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.mavenProjectBuilder.buildWithDependencies(mavenProject, this.localRepository, this.profileManager, transferListener);
    }

    public MavenProject readProjectWithDependencies(File mavenProject) throws ProjectBuildingException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.mavenProjectBuilder.buildWithDependencies(mavenProject, this.localRepository, this.profileManager);
    }

    public List<MavenProject> collectProjects(File basedir, String[] includes, String[] excludes) throws MojoExecutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        List<File> poms = this.getPomFiles(basedir, includes, excludes);
        for (File pom : poms) {
            try {
                MavenProject p = this.readProject(pom);
                projects.add(p);
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Error loading " + pom, (Exception)((Object)e));
            }
        }
        return projects;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.artifactFactory.createArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public void resolve(Artifact artifact, List<?> remoteRepositories, ArtifactRepository localRepositoryToResolveFrom) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.artifactResolver.resolve(artifact, remoteRepositories, localRepositoryToResolveFrom);
    }

    public List<SummaryPluginDescriptor> getAvailablePlugins() {
        ArrayList<SummaryPluginDescriptor> plugins = new ArrayList<SummaryPluginDescriptor>();
        plugins.add(this.makeMockPlugin("org.apache.maven.plugins", "maven-jar-plugin", "Maven Jar Plug-in"));
        plugins.add(this.makeMockPlugin("org.apache.maven.plugins", "maven-compiler-plugin", "Maven Compiler Plug-in"));
        return plugins;
    }

    public PluginDescriptor getPluginDescriptor(SummaryPluginDescriptor summaryPluginDescriptor) throws MavenEmbedderException {
        PluginDescriptor pluginDescriptor;
        try {
            InputStream is = this.classLoader.getResourceAsStream("/plugins/" + summaryPluginDescriptor.getArtifactId() + ".xml");
            pluginDescriptor = this.pluginDescriptorBuilder.build((Reader)new InputStreamReader(is));
        }
        catch (PlexusConfigurationException e) {
            throw new MavenEmbedderException("Error retrieving plugin descriptor.", (Throwable)e);
        }
        return pluginDescriptor;
    }

    private SummaryPluginDescriptor makeMockPlugin(String groupId, String artifactId, String name) {
        return new SummaryPluginDescriptor(groupId, artifactId, name);
    }

    public void execute(MavenProject project, List<?> goals, EventMonitor eventMonitor, TransferListener transferListener, Properties properties, File executionRootDirectory) throws CycleDetectedException, LifecycleExecutionException, BuildFailureException, DuplicateProjectException, MissingProjectException {
        this.execute(Collections.singletonList(project), goals, eventMonitor, transferListener, properties, executionRootDirectory);
    }

    public void execute(List<MavenProject> projects, List<?> goals, EventMonitor eventMonitor, TransferListener transferListener, Properties properties, File executionRootDirectory) throws CycleDetectedException, LifecycleExecutionException, BuildFailureException, DuplicateProjectException, MissingProjectException {
        ReactorManager rm = new ReactorManager(projects);
        DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher();
        eventDispatcher.addEventMonitor(eventMonitor);
        rm.setFailureBehavior("fail-fast");
        MavenSession session = new MavenSession(this.embedder.getContainer(), this.settings, this.localRepository, (EventDispatcher)eventDispatcher, rm, goals, executionRootDirectory.getAbsolutePath(), properties, new Date());
        session.setUsingPOMsFromFilesystem(true);
        if (transferListener != null) {
            this.wagonManager.setDownloadMonitor(transferListener);
        }
        if (properties != null) {
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                System.setProperty(string, value);
            }
        }
        this.lifecycleExecutor.execute(session, rm, session.getEventDispatcher());
    }

    public List<String> getLifecyclePhases() throws MavenEmbedderException {
        ArrayList<String> phases = new ArrayList<String>();
        ComponentDescriptor descriptor = this.embedder.getContainer().getComponentDescriptor(LifecycleExecutor.ROLE);
        PlexusConfiguration configuration = descriptor.getConfiguration();
        PlexusConfiguration[] phasesConfigurations = configuration.getChild("lifecycles").getChild(0).getChild("phases").getChildren("phase");
        try {
            for (int i = 0; i < phasesConfigurations.length; ++i) {
                phases.add(phasesConfigurations[i].getValue());
            }
        }
        catch (PlexusConfigurationException e) {
            throw new MavenEmbedderException("Cannot retrieve default lifecycle phasesConfigurations.", (Throwable)e);
        }
        return phases;
    }

    public ArtifactRepository createLocalRepository(File repository) {
        return this.createLocalRepository(repository.getAbsolutePath(), DEFAULT_LOCAL_REPO_ID);
    }

    public ArtifactRepository createLocalRepository() {
        return this.createLocalRepository(this.settings.getLocalRepository(), DEFAULT_LOCAL_REPO_ID);
    }

    public ArtifactRepository createLocalRepository(String url, String repositoryId) {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        }
        return this.createRepository(url, repositoryId);
    }

    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    private RuntimeInfo createRuntimeInfo() {
        RuntimeInfo runtimeInfo = new RuntimeInfo(this.settings);
        runtimeInfo.setPluginUpdateOverride(Boolean.FALSE);
        return runtimeInfo;
    }

    private List<File> getPomFiles(File basedir, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(basedir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        ArrayList<File> poms = new ArrayList<File>();
        for (int i = 0; i < scanner.getIncludedFiles().length; ++i) {
            poms.add(new File(basedir, scanner.getIncludedFiles()[i]));
        }
        return poms;
    }

    public void start() throws MavenEmbedderException {
        this.detectUserInstallation();
        if (this.classLoader == null) {
            throw new IllegalStateException("A classloader must be specified using setClassLoader(ClassLoader).");
        }
        this.embedder = new Embedder();
        if (this.logger != null) {
            this.embedder.setLoggerManager((LoggerManager)new MavenEmbedderLoggerManager((Logger)new PlexusLoggerAdapter(this.logger)));
        }
        try {
            ClassWorld classWorld = new ClassWorld();
            classWorld.newRealm("plexus.core", this.classLoader);
            this.embedder.start(classWorld);
            this.modelReader = new MavenXpp3Reader();
            this.modelWriter = new MavenXpp3Writer();
            this.pluginDescriptorBuilder = new PluginDescriptorBuilder();
            this.profileManager = new DefaultProfileManager(this.embedder.getContainer(), (Properties)null);
            this.mavenProjectBuilder = (MavenProjectBuilder)this.embedder.lookup(MavenProjectBuilder.ROLE);
            this.artifactRepositoryFactory = (ArtifactRepositoryFactory)this.embedder.lookup(ArtifactRepositoryFactory.ROLE);
            this.artifactFactory = (ArtifactFactory)this.embedder.lookup(ArtifactFactory.ROLE);
            this.artifactResolver = (ArtifactResolver)this.embedder.lookup(ArtifactResolver.ROLE);
            this.artifactMetadataSource = (ArtifactMetadataSource)this.embedder.lookup(ArtifactMetadataSource.ROLE);
            this.defaultArtifactRepositoryLayout = (ArtifactRepositoryLayout)this.embedder.lookup(ArtifactRepositoryLayout.ROLE, DEFAULT_LAYOUT_ID);
            this.lifecycleExecutor = (LifecycleExecutor)this.embedder.lookup(LifecycleExecutor.ROLE);
            this.wagonManager = (WagonManager)this.embedder.lookup(WagonManager.ROLE);
            this.createMavenSettings();
            this.profileManager.loadSettingsProfiles(this.settings);
            this.localRepository = this.createLocalRepository();
        }
        catch (PlexusContainerException e) {
            throw new MavenEmbedderException("Cannot start Plexus embedder.", (Throwable)e);
        }
        catch (DuplicateRealmException e) {
            throw new MavenEmbedderException("Cannot create Classworld realm for the embedder.", (Throwable)e);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException("Cannot lookup required component.", (Throwable)e);
        }
    }

    protected void detectUserInstallation() {
        if (new File(userHome, ".m2").exists()) {
            this.alignWithUserInstallation = true;
        }
    }

    protected void createM2WorkingDir() {
        new File(userHome, ".m2/repository").mkdirs();
    }

    protected void createMavenSettings() throws MavenEmbedderException, ComponentLookupException {
        if (this.alignWithUserInstallation) {
            this.settingsBuilder = (MavenSettingsBuilder)this.embedder.lookup(MavenSettingsBuilder.ROLE);
            try {
                this.settings = this.settingsBuilder.buildSettings();
            }
            catch (IOException e) {
                throw new MavenEmbedderException("Error creating settings.", (Throwable)e);
            }
            catch (XmlPullParserException e) {
                throw new MavenEmbedderException("Error creating settings.", (Throwable)e);
            }
        } else {
            if (this.localRepository == null) {
                this.localRepository = this.createLocalRepository(this.localRepositoryDirectory);
            }
            this.settings = new Settings();
            this.settings.setLocalRepository(this.localRepositoryDirectory.getAbsolutePath());
            this.settings.setRuntimeInfo(this.createRuntimeInfo());
            this.settings.setOffline(this.offline);
            this.settings.setInteractiveMode(this.interactiveMode);
        }
        this.initWagonFromSettings();
    }

    protected void initWagonFromSettings() {
        this.wagonManager.setOnline(!this.isOffline());
        Proxy proxy = this.settings.getActiveProxy();
        if (proxy != null) {
            this.wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
        }
    }

    public void stop() throws MavenEmbedderException {
        try {
            this.embedder.release((Object)this.mavenProjectBuilder);
            this.embedder.release((Object)this.artifactRepositoryFactory);
            this.embedder.release((Object)this.settingsBuilder);
            this.embedder.release((Object)this.lifecycleExecutor);
        }
        catch (ComponentLifecycleException e) {
            throw new MavenEmbedderException("Cannot stop the embedder.", (Throwable)e);
        }
    }
}

