/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuxeo.build.maven.AntBuildMojo;

public class VerifyMojo
extends AntBuildMojo {
    private File summaryFile;

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        FailsafeSummary summary;
        try {
            summary = !this.summaryFile.isFile() ? new FailsafeSummary() : this.readSummary();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        int result = summary.getResult();
        if (result == 0) {
            return;
        }
        throw new MojoFailureException("There are some test failures.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FailsafeSummary readSummary() throws IOException, XmlPullParserException {
        FailsafeSummary failsafeSummary;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.summaryFile)), this.getEncoding());
            FailsafeSummaryXpp3Reader xpp3Reader = new FailsafeSummaryXpp3Reader();
            failsafeSummary = xpp3Reader.read((Reader)reader);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return failsafeSummary;
    }
}

