/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class AndFilter
extends CompositeFilter {
    public AndFilter() {
    }

    public AndFilter(List<Filter> filters) {
        super(filters);
    }

    @Override
    public boolean accept(Edge edge) {
        for (Filter filter : this.filters) {
            if (filter.accept(edge)) continue;
            if (MavenClientFactory.getLog().isDebugEnabled()) {
                MavenClientFactory.getLog().debug("Filtering - " + filter + " refused " + edge);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(Artifact artifact) {
        for (Filter filter : this.filters) {
            if (filter.accept(artifact)) continue;
            if (MavenClientFactory.getLog().isDebugEnabled()) {
                MavenClientFactory.getLog().debug("Filtering - " + filter + " refused " + artifact);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(Node node) {
        for (Filter filter : this.filters) {
            boolean accept = filter.accept(node);
            if (accept) continue;
            if (MavenClientFactory.getLog().isDebugEnabled()) {
                MavenClientFactory.getLog().debug("Filtering - " + filter + " refused " + node);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("" + this.getClass());
        for (Filter filter : this.filters) {
            sb.append(System.getProperty("line.separator") + filter);
        }
        return sb.toString();
    }
}

