/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.SegmentMatch;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class VersionFilter
implements Filter {
    protected SegmentMatch matcher;

    public String toString() {
        return "" + this.getClass() + " [" + this.matcher + "]";
    }

    public VersionFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public VersionFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    public boolean match(String segment) {
        return this.matcher.match(segment);
    }

    public boolean accept(Edge edge, Dependency dep) {
        return this.matcher.match(dep.getVersion());
    }

    @Override
    public boolean accept(Edge edge) {
        return this.matcher.match(edge.out.getArtifact().getVersion());
    }

    @Override
    public boolean accept(Artifact artifact) {
        return this.matcher.match(artifact.getVersion());
    }

    @Override
    public boolean accept(Node node) {
        return this.accept(node.getArtifact());
    }
}

