/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.nuxeo.build.swing.ArtifactTable;
import org.nuxeo.build.swing.Filter;

public class ArtifactTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected TreeMap<String, ArtifactRow> map = new TreeMap();
    protected LinkedHashSet<String> columns = new LinkedHashSet();
    protected List<ArtifactRow> visibleRows;
    protected List<String> visibleColumns = new ArrayList<String>();
    protected Filter filter;
    protected ArtifactTable table;

    public ArtifactTableModel(ArtifactTable table) {
        this.visibleColumns.add("Artifact");
        this.visibleRows = new ArrayList<ArtifactRow>();
        this.table = table;
    }

    public List<String> getColumns() {
        return new ArrayList<String>(this.columns);
    }

    public List<String> getVisibleColumns() {
        return this.visibleColumns;
    }

    public List<ArtifactRow> getVisibleRows() {
        return this.visibleRows;
    }

    public TreeMap<String, ArtifactRow> getMap() {
        return this.map;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.visibleRows.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.visibleColumns.get(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ArtifactRow row = this.visibleRows.get(rowIndex);
        if (columnIndex == 0) {
            return row.key;
        }
        return row.getValue(this.visibleColumns.get(columnIndex));
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex > 0) {
            ArtifactRow row = this.visibleRows.get(rowIndex);
            row.setValue(this.visibleColumns.get(columnIndex), (Boolean)value);
        }
        this.table.setDirty(true);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? String.class : Boolean.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public void addColumn(String column) {
        this.columns.add(column);
        this.visibleColumns.add(column);
        this.fireTableStructureChanged();
    }

    public void removeColumn(String column) {
        this.columns.remove(column);
        this.visibleColumns.remove(column);
        this.fireTableStructureChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file) throws IOException {
        FileOutputStream in = new FileOutputStream(file);
        try {
            this.store(in);
        }
        finally {
            ((OutputStream)in).close();
        }
    }

    public void store(OutputStream out) {
        PrintStream printer = new PrintStream(out);
        for (ArtifactRow row : this.map.values()) {
            printer.print(row.key);
            int len = row.profiles.size() - 1;
            if (len == -1) {
                printer.println();
                continue;
            }
            printer.print("?");
            for (int i = 0; i < len; ++i) {
                printer.print(row.profiles.get(i));
                printer.print(",");
            }
            printer.println(row.profiles.get(len));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.load(in);
        }
        finally {
            in.close();
        }
    }

    public void load(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                line = reader.readLine();
                continue;
            }
            int p = line.indexOf("?");
            String key = null;
            if (p == -1) {
                key = line;
                line = null;
            } else {
                key = line.substring(0, p);
                line = line.substring(p + 1);
            }
            ArtifactRow row = new ArtifactRow(key);
            if (line != null) {
                this.readTokens(line, row);
            }
            this.map.put(row.key, row);
            line = reader.readLine();
        }
        this.build();
    }

    public synchronized void build() {
        this.visibleColumns = new ArrayList<String>();
        this.visibleColumns.add("Artifacts");
        for (String col : this.columns) {
            this.visibleColumns.add(col);
        }
        this.buildRows(false);
        this.fireTableStructureChanged();
    }

    public synchronized void buildRows() {
        this.buildRows(true);
    }

    public synchronized void buildRows(boolean refresh) {
        this.visibleRows = new ArrayList<ArtifactRow>();
        if (this.filter == null) {
            for (ArtifactRow row : this.map.values()) {
                this.visibleRows.add(row);
            }
        } else {
            for (ArtifactRow row : this.map.values()) {
                if (!this.filter.acceptRow(row.key)) continue;
                this.visibleRows.add(row);
            }
        }
        if (refresh) {
            this.fireTableDataChanged();
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (this.filter != filter) {
            this.filter = filter;
            this.buildRows();
        }
    }

    private void readTokens(String text, ArtifactRow row) {
        StringTokenizer tokenizer = new StringTokenizer(text, ",");
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken().trim();
            row.setValue(tok, Boolean.TRUE);
            this.columns.add(tok);
        }
    }

    static class ArtifactRow {
        protected String key;
        protected List<String> profiles;

        public ArtifactRow(String key) {
            this.key = key;
            this.profiles = new ArrayList<String>();
        }

        public Boolean getValue(String rowKey) {
            int len = this.profiles.size();
            for (int i = 0; i < len; ++i) {
                if (!rowKey.equals(this.profiles.get(i))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public void setValue(String key, Boolean value) {
            if (!value.booleanValue()) {
                int len = this.profiles.size();
                for (int i = 0; i < len; ++i) {
                    if (!key.equals(this.profiles.get(i))) continue;
                    this.profiles.remove(i);
                }
            } else {
                int len = this.profiles.size();
                for (int i = 0; i < len; ++i) {
                    if (!key.equals(this.profiles.get(i))) continue;
                    return;
                }
                this.profiles.add(key);
            }
        }
    }
}

