/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.nuxeo.build.swing.ArtifactTable;
import org.nuxeo.build.swing.PrintUtilities;
import org.nuxeo.build.swing.tree.ArtifactTreeDialog;

public class Main {
    static ArtifactTable table;
    static JFrame frame;

    protected static void createAndShowGUI(File file) throws IOException {
        frame = new JFrame("Assembly Editor");
        frame.setDefaultCloseOperation(3);
        table = new ArtifactTable(frame);
        if (file != null) {
            table.loadFile(file);
        }
        frame.setTitle("Assembly Editor - " + (file == null ? "Untitled" : file.getName()));
        frame.getContentPane().add(table);
        frame.setJMenuBar(Main.createMenuBar());
        frame.pack();
        frame.setSize(800, 600);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        frame.setLocation((screenSize.width - frame.getWidth()) / 2, (screenSize.height - frame.getHeight()) / 2);
        frame.setVisible(true);
    }

    public static JMenuBar createMenuBar() {
        ActionListener actionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String cmd = e.getActionCommand();
                    if ("Open".equals(cmd)) {
                        table.open();
                    } else if ("Save".equals(cmd)) {
                        table.save();
                    } else if ("Save As".equals(cmd)) {
                        JFileChooser fc = new JFileChooser();
                        int r = fc.showSaveDialog(table);
                        if (r == 0) {
                            table.saveAs(fc.getSelectedFile());
                        }
                    } else if ("Print".equals(cmd)) {
                        PrintUtilities.printComponent(Main.table.table);
                    } else if ("Exit".equals(cmd)) {
                        System.exit(0);
                    }
                }
                catch (IOException ee) {
                    JOptionPane.showMessageDialog(table, ee.getMessage(), "Error", 0);
                }
            }
        };
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem open = new JMenuItem("Open", 79);
        open.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        open.addActionListener(actionHandler);
        JMenuItem save = new JMenuItem("Save", 83);
        save.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        save.addActionListener(actionHandler);
        JMenuItem saveas = new JMenuItem("Save As", 65);
        saveas.setAccelerator(KeyStroke.getKeyStroke(65, 4));
        saveas.addActionListener(actionHandler);
        JMenuItem exit = new JMenuItem("Exit", 88);
        exit.setAccelerator(KeyStroke.getKeyStroke(88, 4));
        exit.addActionListener(actionHandler);
        JMenuItem print = new JMenuItem("Print", 80);
        print.setAccelerator(KeyStroke.getKeyStroke(80, 4));
        print.addActionListener(actionHandler);
        menu.add(open);
        menu.add(save);
        menu.add(saveas);
        menu.addSeparator();
        menu.add(print);
        menu.addSeparator();
        menu.add(exit);
        menu = new JMenu("Edit");
        menuBar.add(menu);
        JMenuItem addArtifact = new JMenuItem("Add Artifact", 65);
        addArtifact.setAccelerator(KeyStroke.getKeyStroke(10, 4));
        addArtifact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.openAddArtifactDialog();
            }
        });
        JMenuItem removeArtifact = new JMenuItem("Remove Artifacts", 82);
        removeArtifact.setAccelerator(KeyStroke.getKeyStroke(8, 4));
        removeArtifact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.deleteSelectedArtifacts();
            }
        });
        JMenuItem profiles = new JMenuItem("Profiles Management", 80);
        profiles.setAccelerator(KeyStroke.getKeyStroke(77, 4));
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.openProfilesDialog();
            }
        });
        JMenuItem browse = new JMenuItem("Artifact Browser", 66);
        browse.setAccelerator(KeyStroke.getKeyStroke(69, 4));
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArtifactTreeDialog dlg = ArtifactTreeDialog.getInstance();
                dlg.setLocationRelativeTo(table);
                dlg.setVisible(true);
            }
        });
        menu.add(addArtifact);
        menu.add(removeArtifact);
        menu.addSeparator();
        menu.add(profiles);
        menu.add(browse);
        return menuBar;
    }

    public static void main(String[] args) {
        final File file = args.length == 1 ? new File(args[0]) : null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main.createAndShowGUI(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
    }
}

