/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.MavenExclusionFilter;
import org.nuxeo.build.maven.filter.NotFilter;
import org.nuxeo.build.maven.graph.Node;

public class ExpandTask
extends Task {
    public String key;
    public int depth = 1;
    public AndFilter filter = new AndFilter();
    protected Filter exclusionFilter = new MavenExclusionFilter();

    public ExpandTask() {
        this.filter.addFilter(new MavenExclusionFilter());
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDepth(String depth) {
        this.depth = "all".equals(depth) ? Integer.MAX_VALUE : Integer.parseInt(depth);
    }

    public void addExcludes(Excludes excludes) {
        if (this.filter == null) {
            this.filter = new AndFilter();
        }
        this.filter.addFilter(new NotFilter(excludes.getFilter()));
    }

    public void addIncludes(Includes includes) {
        if (this.filter == null) {
            this.filter = new AndFilter();
        }
        this.filter.addFilter(includes.getFilter());
    }

    public void setMavenExclusions(Boolean value) {
        if (value == Boolean.TRUE) {
            this.filter.addFilter(this.exclusionFilter);
        } else {
            this.filter.removeFilter(this.exclusionFilter);
        }
    }

    protected boolean acceptNode(Node node) {
        return true;
    }

    public void execute() throws BuildException {
        Collection<Node> nodes = null;
        MavenClient maven = MavenClientFactory.getInstance();
        nodes = this.key == null ? maven.getGraph().getRoots() : maven.getGraph().find(this.key);
        for (Node node : nodes) {
            if (!this.acceptNode(node)) continue;
            if (this.filter != null) {
                node.expand(this.depth, CompositeFilter.compact(this.filter));
                continue;
            }
            node.expand(this.depth, null);
        }
    }
}

