/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.ant.artifact.ExpandTask;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class NuxeoExpandTask
extends ExpandTask {
    public NuxeoExpandTask() {
        Filter scopeFilter = new Filter(){

            public boolean accept(Edge edge, Dependency dep) {
                String depScope = dep.getScope();
                String groupId = edge.dst.getArtifact().getGroupId();
                return "compile".equals(depScope) || "runtime".equals(depScope) || "provided".equals(depScope) && groupId.startsWith("org.nuxeo");
            }

            public boolean accept(Artifact artifact) {
                return true;
            }

            public boolean accept(Edge edge) {
                return true;
            }

            public boolean accept(Node node) {
                return true;
            }
        };
        this.filter.addFilter(scopeFilter);
        this.setDepth("all");
        this.setMavenExclusions(Boolean.TRUE);
    }

    protected boolean acceptNode(Node node) {
        return node.getArtifact().getGroupId().startsWith("org.nuxeo");
    }
}

