/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.VersionManagement;

public class ResolveFile
extends FileResource {
    public String key;
    public String classifier;

    public void setKey(String pattern) {
        int p = pattern.lastIndexOf(59);
        if (p > -1) {
            this.key = pattern.substring(0, p);
            this.classifier = pattern.substring(p + 1);
        } else {
            this.key = pattern;
        }
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    protected File resolveFile() throws ArtifactNotFoundException {
        MavenClient maven = MavenClientFactory.getInstance();
        ArtifactDescriptor ad = new ArtifactDescriptor(this.key);
        if (ad.classifier != null) {
            this.classifier = ad.classifier;
        } else if (this.classifier != null) {
            ad.classifier = this.classifier;
        }
        if (ad.version == null) {
            VersionManagement versionManagement = maven.getGraph().getVersionManagement();
            ad.version = versionManagement.getVersion(ad);
            if (ad.version == null) {
                throw new BuildException("Version is required since not found in dependency management: " + ad);
            }
        }
        Artifact artifact = maven.getArtifactFactory().createDependencyArtifact(ad.groupId, ad.artifactId, VersionRange.createFromVersion((String)ad.version), ad.type, ad.classifier, ad.scope);
        MavenClientFactory.getInstance().resolve(artifact);
        return artifact.getFile();
    }

    public File getFile() {
        if (this.isReference()) {
            return ((FileResource)this.getCheckedRef()).getFile();
        }
        try {
            return this.resolveFile();
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Failed to resolve file: " + this.key + "; classifier: " + this.classifier, (Throwable)e);
        }
    }

    public File getBaseDir() {
        return this.isReference() ? ((FileResource)this.getCheckedRef()).getBaseDir() : this.getFile().getParentFile();
    }
}

