/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.ManifestBundleCategoryPatternFilter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class DependsOnCategoryPatternFilter
implements Filter {
    private AndFilter categoryFilter;
    private String pattern;

    public DependsOnCategoryPatternFilter(String pattern) {
        this.pattern = pattern;
        this.categoryFilter = new AndFilter();
        this.categoryFilter.addFilter(ManifestBundleCategoryPatternFilter.class, pattern);
    }

    public boolean accept(Edge edge, Dependency dep) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean accept(Artifact artifact) {
        return this.categoryFilter.accept(artifact);
    }

    public boolean accept(Edge edge) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean accept(Node node) {
        if (!node.getArtifact().getGroupId().startsWith("org.nuxeo")) {
            return false;
        }
        boolean accept = this.accept(node.getArtifact());
        if (MavenClientFactory.getLog().isDebugEnabled()) {
            MavenClientFactory.getLog().debug(DependsOnCategoryPatternFilter.class + " filtering " + node.getArtifact() + " on pattern " + this.pattern + " ...");
        }
        Collection<Edge> children = node.getEdgesOut();
        if (!accept && children != null) {
            for (Edge childEdge : children) {
                if (!this.accept(childEdge.dst)) continue;
                accept = true;
                break;
            }
        }
        if (MavenClientFactory.getLog().isDebugEnabled()) {
            MavenClientFactory.getLog().debug("Filtering on pattern " + this.pattern + " result for " + node.getArtifact() + " : " + accept);
        }
        return accept;
    }
}

