/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class MavenExclusionFilter
implements Filter {
    protected boolean recurseAccept(Edge edge, Dependency dep) {
        if (edge == null) {
            return true;
        }
        if (MavenClientFactory.getLog().isDebugEnabled()) {
            MavenClientFactory.getLog().debug("Evaluating Exclusion Filter  - " + edge + " against " + dep.getArtifactId());
        }
        for (Exclusion e : edge.exclusions) {
            String groupId;
            String artifactId = e.getArtifactId();
            if (artifactId == null) {
                artifactId = dep.getArtifactId();
            }
            if ((groupId = e.getGroupId()) == null) {
                groupId = dep.getGroupId();
            }
            if (!dep.getArtifactId().equals(artifactId) || !dep.getGroupId().equals(groupId)) continue;
            return false;
        }
        return this.recurseAccept(edge.from, dep);
    }

    public boolean accept(Edge edge, Dependency dep) {
        return this.recurseAccept(edge, dep);
    }

    public boolean accept(Artifact artifact) {
        return true;
    }

    public boolean accept(Edge edge) {
        return true;
    }

    public boolean accept(Node node) {
        return true;
    }
}

