/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.DependencyFilter;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    public final Graph graph;
    public final Edge from;
    public final Node src;
    public final Node dst;
    public final boolean isOptional;
    public final String scope;
    public final List<Exclusion> exclusions;
    protected final Dependency dep;

    public Edge(Node node) {
        this.graph = node.graph;
        this.from = null;
        this.src = node;
        this.dst = node;
        this.isOptional = false;
        this.scope = "compile";
        this.exclusions = Collections.emptyList();
        this.dep = new Dependency();
    }

    public Edge(Edge from, Node src, Node dst, Dependency d) {
        this.graph = from.graph;
        this.from = from;
        this.src = src;
        this.dst = dst;
        this.dep = d;
        this.scope = d.getScope();
        this.isOptional = d.isOptional();
        this.exclusions = Collections.unmodifiableList(d.getExclusions());
    }

    public void expand(int recurse, DependencyFilter filter) {
        if (recurse <= 0) {
            return;
        }
        if (this.dst.isExpanded) {
            return;
        }
        MavenProject pom = this.dst.getPom();
        if (pom == null) {
            return;
        }
        String type = this.dst.getArtifact().getType();
        boolean shouldLoadDependencyManagement = this.graph.shouldLoadDependencyManagement();
        if ("pom".equals(type) && shouldLoadDependencyManagement) {
            this.expand(recurse, pom.getDependencyManagement().getDependencies(), filter);
        }
        this.expand(recurse, pom.getDependencies(), filter);
    }

    protected void expand(int recurse, List<Dependency> deps, DependencyFilter filter) {
        this.dst.isExpanded = true;
        ArtifactFactory factory = this.graph.getMaven().getArtifactFactory();
        for (Dependency d : deps) {
            if ("test".equalsIgnoreCase(d.getScope()) || "system".equalsIgnoreCase(d.getScope()) || d.isOptional() || filter != null && !filter.accept(this, d)) {
                if (!MavenClientFactory.getLog().isDebugEnabled()) continue;
                MavenClientFactory.getLog().info("Filtering " + this.dst + "  - refused " + d.toString());
                continue;
            }
            Artifact a = factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), d.getType(), d.getClassifier(), d.getScope(), false);
            assert (a.getScope().equals(d.getScope()));
            Node newNode = this.graph.getNode(this.dst, a);
            if (!d.getExclusions().isEmpty() && newNode.isExpanded) {
                newNode.unexpand();
            }
            Edge newEdge = new Edge(this, this.dst, newNode, d);
            this.dst.addEdgeOut(newNode, newEdge);
            newNode.addEdgeIn(this.dst, newEdge);
            if (recurse <= 0 || newNode.isExpanded) continue;
            newEdge.expand(recurse - 1, filter);
        }
    }

    public String toString() {
        return "edge - " + this.src + " -> " + this.dst;
    }

    public static void print(Edge edge) {
        Edge.recursePrint(edge, 0);
    }

    protected static int recursePrint(Edge edge, int level) {
        if (edge == null) {
            return level;
        }
        if (level > 100) {
            System.out.println("Cutting, maximum depth");
            return level;
        }
        level = Edge.recursePrint(edge.from, level + 1);
        System.out.println(String.format("%04d %s", level, edge));
        return level - 1;
    }
}

