/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.nuxeo.build.ant.artifact.GraphTask;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.VersionManagement;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.maven.graph.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph {
    protected MavenClient maven;
    protected Node root;
    protected LinkedList<Node> roots = new LinkedList();
    protected TreeMap<String, Node> nodes = new TreeMap();
    protected Resolver resolver = new Resolver(this);
    protected Map<String, Artifact> file2artifacts = new HashMap<String, Artifact>();
    protected VersionManagement vmgr;
    protected boolean shouldLoadDependencyManagement = false;

    public Graph(MavenClient maven) {
        this.maven = maven;
        this.vmgr = new VersionManagement();
    }

    public VersionManagement getVersionManagement() {
        return this.vmgr;
    }

    public void setShouldLoadDependencyManagement(boolean shouldLoadDependencyManagement) {
        this.shouldLoadDependencyManagement = shouldLoadDependencyManagement;
    }

    public boolean shouldLoadDependencyManagement() {
        return this.shouldLoadDependencyManagement;
    }

    public MavenClient getMaven() {
        return this.maven;
    }

    public List<Node> getRoots() {
        return this.roots;
    }

    public Collection<Node> getNodes() {
        return this.nodes.values();
    }

    public Artifact getArtifactByFile(String fileName) {
        return this.file2artifacts.get(fileName);
    }

    public void collectNodes(Collection<Node> nodesToCollect) {
        for (Node node : this.roots) {
            node.collectNodes(nodesToCollect);
        }
    }

    public void collectNodes(Collection<Node> nodesToCollect, Filter filter) {
        for (Node node : this.roots) {
            node.collectNodes(nodesToCollect, filter);
        }
    }

    public Node[] getNodesArray() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    public TreeMap<String, Node> getNodesTree() {
        return this.nodes;
    }

    public Node findFirst(String pattern) {
        return this.findFirst(pattern, false);
    }

    public Node findFirst(String pattern, boolean stopIfNotUnique) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        int size = map.size();
        if (size == 0) {
            return null;
        }
        if (stopIfNotUnique && size > 1) {
            throw new BuildException("Pattern '" + pattern + "' cannot be resolved to a unique node. Matching nodes are: " + map.values());
        }
        return (Node)map.get(map.firstKey());
    }

    public Collection<Node> find(String pattern) {
        SortedMap<String, Node> map = this.nodes.subMap(pattern + ':', pattern + ';');
        return map.values();
    }

    public Node addRootNode(MavenProject pom) {
        Artifact artifact = pom.getArtifact();
        String key = Node.createNodeId(artifact);
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this, pom, artifact, key);
            this.nodes.put(node.getId(), node);
            this.roots.add(node);
        }
        return node;
    }

    public Node addRootNode(String key) {
        ArtifactDescriptor ad = new ArtifactDescriptor(key);
        Artifact artifact = GraphTask.readArtifact(ad);
        return this.getRootNode(artifact);
    }

    public Node getRootNode(Artifact artifact) {
        String key = Node.createNodeId(artifact);
        Node node = this.nodes.get(key);
        if (node == null) {
            node = new Node(this, null, artifact, key);
            this.nodes.put(node.getId(), node);
            this.roots.add(node);
        }
        return node;
    }

    public Node getNode(Node parent, Artifact artifact) {
        String artifactKey = Node.createNodeId(artifact);
        Node node = this.nodes.get(artifactKey);
        if (node == null) {
            node = new Node(this, null, artifact, artifactKey);
            this.nodes.put(node.getId(), node);
        }
        return node;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Node lookup(String id) {
        return this.nodes.get(id);
    }

    public Node lookup(Artifact artifact) {
        return this.lookup(Node.createNodeId(artifact));
    }

    public Node findNode(ArtifactDescriptor ad) {
        String key = ad.getNodeKeyPattern();
        Collection<Node> nodesToParse = null;
        nodesToParse = key == null ? this.getNodes() : this.find(key);
        Node returnNode = null;
        for (Node node : nodesToParse) {
            Artifact artifact = node.getArtifact();
            if (ad.artifactId != null && !ad.artifactId.equals(artifact.getArtifactId()) || ad.groupId != null && !ad.groupId.equals(artifact.getGroupId()) || ad.version != null && !ad.version.equals(artifact.getVersion()) || ad.type != null && !ad.type.equals(artifact.getType())) continue;
            try {
                if (returnNode != null && artifact.getSelectedVersion().compareTo((Object)returnNode.getArtifact().getSelectedVersion()) < 0) {
                    continue;
                }
            }
            catch (OverConstrainedVersionException e) {
                MavenClientFactory.getLog().error("Versions comparison failed on " + artifact, e);
            }
            returnNode = node;
        }
        return returnNode;
    }

    public MavenProject loadPom(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.maven.getProjectBuilder().buildFromRepository(this.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.maven.getRemoteRepositories(), this.maven.getLocalRepository());
        }
        catch (Exception e) {
            MavenClientFactory.getLog().error(e.getMessage(), e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        map.put("org.nuxeo:core:", "org.nuxeo:core");
        map.put("org.nuxeo:core:e", "org.nuxeo:coree");
        map.put("org.nuxeo:coree", "org.nuxeo:core:test");
        map.put("org.nuxeo:common", "org.nuxeo:common");
        map.put("org.nuxeo:clear", "org.nuxeo:clear");
        map.put("org.nuxeos", "org.nuxeos");
        map.put("com", "com");
        map.put("pom", "pom");
        map.put("a:b:c:d", "a:b:c:d");
        map.put("a:b:d", "a:b:d");
        map.put("b", "b");
        System.out.println(map);
        SortedMap smap = map.subMap("org.nuxeo:core:", "org.nuxeo:core:\u0000");
        System.out.println(smap.size() + " - " + smap);
    }
}

