/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.maven.filter.DependencyFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    protected Graph graph;
    protected String id;
    protected Artifact artifact;
    protected List<Edge> edgesIn;
    protected List<Edge> edgesOut;
    protected boolean isExpanded;
    protected MavenProject pom;
    private List<char[]> acceptedCategories;

    public List<char[]> getAcceptedCategories() {
        if (this.acceptedCategories == null) {
            this.acceptedCategories = new ArrayList<char[]>();
        }
        return this.acceptedCategories;
    }

    public static String createNodeId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion() + ':' + artifact.getType() + ':';
    }

    public Node(Node node) {
        this.graph = node.graph;
        this.id = node.id;
        this.artifact = node.artifact;
        this.edgesIn = node.edgesIn;
        this.edgesOut = node.edgesOut;
        this.pom = node.pom;
        this.isExpanded = node.isExpanded;
    }

    public Node(Graph graph, MavenProject pom, Artifact artifact) {
        this(graph, pom, artifact, Node.createNodeId(artifact));
    }

    protected Node(Graph graph, MavenProject pom, Artifact artifact, String id) {
        this.graph = graph;
        this.id = id;
        this.artifact = artifact;
        this.pom = pom;
        this.edgesIn = new ArrayList<Edge>();
        this.edgesOut = new ArrayList<Edge>();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public File getFile() {
        this.graph.getResolver().resolve(this);
        File file = this.artifact.getFile();
        if (file != null) {
            this.graph.file2artifacts.put(file.getName(), this.artifact);
        }
        return file;
    }

    public File getFile(String classifier) {
        this.graph.getResolver().resolve(this);
        Artifact ca = this.graph.maven.getArtifactFactory().createArtifactWithClassifier(this.artifact.getGroupId(), this.artifact.getArtifactId(), this.artifact.getVersion(), this.artifact.getType(), classifier);
        try {
            this.graph.maven.resolve(ca);
            File file = ca.getFile();
            if (file != null) {
                this.graph.file2artifacts.put(file.getAbsolutePath(), ca);
            }
            return file;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean isRoot() {
        return this.edgesIn.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public Collection<Edge> getEdgesOut() {
        return this.edgesOut;
    }

    protected static String dependencyId(Dependency dep) {
        String groupId = StringUtils.defaultString((Object)dep.getGroupId());
        String artifactId = StringUtils.defaultString((Object)dep.getArtifactId());
        String version = StringUtils.defaultString((Object)dep.getVersion());
        String type = StringUtils.defaultString((Object)dep.getType());
        String classifier = StringUtils.defaultString((Object)dep.getClassifier());
        return String.format("%s:%s:%s:%s:%s", groupId, artifactId, version, type, classifier);
    }

    public Collection<Edge> getEdgesIn() {
        return this.edgesIn;
    }

    protected void addEdgeIn(Node node, Edge edge) {
        this.edgesIn.add(edge);
    }

    protected void addEdgeOut(Node node, Edge edge) {
        this.edgesOut.add(edge);
    }

    public MavenProject getPom() {
        if (this.pom == null) {
            this.graph.getResolver().resolve(this);
        }
        return this.pom;
    }

    public MavenProject getPomIfAlreadyLoaded() {
        return this.pom;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void expand(int recurse, DependencyFilter filter) {
        if (this.isExpanded) {
            return;
        }
        Edge edge = new Edge(this);
        edge.expand(recurse, filter);
    }

    public void expand(DependencyFilter filter) {
        this.expand(0, filter);
    }

    public void expandAll(DependencyFilter filter) {
        this.expand(Integer.MAX_VALUE, filter);
    }

    public List<Node> getTrail() {
        if (this.edgesIn.isEmpty()) {
            ArrayList<Node> result = new ArrayList<Node>();
            result.add(this);
            return result;
        }
        Edge edge = this.edgesIn.get(0);
        List<Node> path = edge.src.getTrail();
        path.add(this);
        return path;
    }

    protected void unexpand() {
        this.isExpanded = false;
        Iterator<Edge> it = this.edgesOut.iterator();
        while (it.hasNext()) {
            Edge e = it.next();
            it.remove();
            e.src.edgesIn.remove(e);
            e.dst.unexpand();
        }
    }

    public void collectNodes(Collection<Node> nodes, Filter filter) {
        for (Edge edge : this.edgesOut) {
            if (!filter.accept(edge)) continue;
            nodes.add(edge.dst);
        }
    }

    public void collectNodes(Collection<Node> nodes) {
        for (Edge edge : this.edgesOut) {
            nodes.add(edge.dst);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return ((Node)obj).id.equals(this);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public void setAcceptedCategory(char[] pattern) {
        this.getAcceptedCategories().add(pattern);
    }

    public boolean isAcceptedCategory(List<char[]> patterns) {
        for (char[] pattern : patterns) {
            if (!this.getAcceptedCategories().contains(pattern)) continue;
            return true;
        }
        return false;
    }
}

