/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Relocation;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class Resolver {
    protected Graph graph;

    public Resolver(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public MavenProject resolve(Node node) {
        if (node.pom != null) {
            return node.pom;
        }
        MavenProject pom = this.loadPom(node.artifact);
        if (pom == null) {
            return null;
        }
        pom = this.checkRelocation(node, pom);
        try {
            if (!node.artifact.isResolved()) {
                this.graph.maven.resolve(node.artifact);
            }
        }
        catch (ArtifactNotFoundException e) {
            MavenClientFactory.getLog().warn(e.getMessage());
        }
        node.pom = pom;
        return node.pom;
    }

    private MavenProject checkRelocation(Node node, MavenProject pom) {
        Relocation reloc;
        DistributionManagement dm = pom.getDistributionManagement();
        if (dm != null && (reloc = dm.getRelocation()) != null) {
            Artifact artifact;
            Artifact orig = artifact = node.artifact;
            String artifactId = reloc.getArtifactId();
            String groupId = reloc.getGroupId();
            String version = reloc.getVersion();
            if (artifactId == null) {
                artifactId = artifact.getArtifactId();
            }
            if (groupId == null) {
                groupId = artifact.getGroupId();
            }
            if (version == null) {
                version = artifact.getVersion();
            }
            node.artifact = this.graph.maven.getArtifactFactory().createArtifact(groupId, artifactId, version, artifact.getScope(), artifact.getType());
            MavenClientFactory.getLog().info("Artifact " + orig + " was relocated to:  " + node.artifact);
            pom = this.loadPom(node.artifact);
        }
        return pom;
    }

    public MavenProject loadPom(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.graph.maven.getProjectBuilder().buildFromRepository(this.graph.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.graph.maven.getRemoteRepositories(), this.graph.maven.getLocalRepository());
        }
        catch (ProjectBuildingException e) {
            MavenClientFactory.getLog().error("Error loading POM of " + artifact, e);
            return null;
        }
    }
}

